# tapis_tenant

This module provides a Drupal integration for Tapis sites & tenants.

## Overview
Tapis has the notion of sites & tenants (https://tapis.readthedocs.io/en/latest/technical/authentication.html). All resources within Tapis (e.g., users, systems, apps, jobs, etc.) are tied to a tenant, and a site can have multiple tenants.
Since our Tapis modules integrate various Tapis resources with Drupal (e.g., apps, systems, etc.), there also needs to be a way to manage the corresponding Tapis sites & tenants from Drupal. That is what this module offers.

In short, this module adds Drupal support for Tapis sites & tenants, allowing site admins to connect existing Tapis sites & tenants to the Drupal site.
This enables other resources (like apps, systems, etc.) to be created within certain Tapis tenants via Drupal, and a Drupal site can now have Tapis resources spanning multiple sites & tenants.

Tapis site & tenant are created as custom content types within Drupal.

## Tapis modules setup guide

### Pre-requisites:
- Install the following modules (in this order):
  - `tapis_tenant`
  - `tapis_auth`
  - `tapis_system`
  - `tapis_app`
  - `tapis_job`
- Information needed for Tapis site from your administrator:
  - Tapis site id
  - Tapis site Admin tenant id (Note: This is different than tapis tenant id)
  - Tapis site Admin tenant API endpoint (Note: This is different than tapis tenant API endpoint)
  - Tapis site authenticator service password
- Information needed for Tapis tenant from your administrator:
  - Dev tenant ID (Note: This is different than tapis admin tenant id)
  - Dev tenant API endpoint (Note: This is different than tapis admin tenant API endpoint)
  - *Service account name*: `admin_drupal`
  - *Satellite proxy URL*: https://api.apps.tenant1.onescienceplace.org
  - *Companion proxy Host*: api.apps.tenant1.onescienceplace.org
  - *Apps base domain*: apps.tenant1.onescienceplace.org
- Information needed to a Linux host on EC2 as Tapis system from its administrator:
  - System account + private/public key pair for Testing EC2 Tapis System

### Steps:
### A. Tapis Site setup
1. Create a new Tapis site content type instance (e.g., `Tapis site 1`).
2. Fill in the following fields:
  - `Tapis site id`: Tapis site id
  - `Tapis site Admin tenant id`: Tapis site Admin tenant id (Note: This is different than tapis tenant id)
  - `Tapis site Admin tenant API endpoint`: Tapis site Admin tenant API endpoint (Note: This is different than tapis tenant API endpoint)
  - `Tapis site authenticator service password`: Tapis site authenticator service password
3. Save the node.

### B. Tapis Tenant setup
1. Tapis tenant requires a Tapis site (refer to section A)
2. Create a new Tapis tenant content type instance (e.g., `Dev tenant 1`).
2. Fill in the following fields:
  - `Tapis site`: Tapis site above
  - `Tapis tenant id`: Dev tenant ID (Note: This is different than tapis admin tenant id)
  - `Tapis tenant API endpoint`: Dev tenant API endpoint (Note: This is different than tapis admin tenant API endpoint)
  - `Tapis tenant service account name`: admin_drupal
  - `Tapis tenant service account password`: *Service account password*
  - `Tapis tenant satellite proxy URL`: *Satellite proxy URL*
  - `Tapis tenant companion proxy Host`: *Companion proxy Host*
  - `Tapis tenant apps base domain`: *Apps base domain*
3. Save the node.

### C. Tapis System setup
1. Tapis system requires Tapis tenant (refer to section B)
2. Create a new System entity instance (e.g., `Dev system 1`).
  - `Tapis tenant`: Dev tenant above
  - Tapis id: something like `aws.suramesh.tapis_system.primary.devenv.7` (but use a different value!)
  - Enabled: `true`
  - System type: `LINUX`
  - Host: `52.9.136.88`
  - Port: `22`
  - Use static system user: `true`
    - Effective user: `ubuntu` (or whatever system name is assigned to you for the EC2 Tapis system)
  - Companion Proxy IP address: 54.183.82.136
  - Companion Proxy Port: 443
  - Root directory: `/home/ubuntu/tapis_system`
  - **Jobs section**:
    - Can execute jobs: `true`
    - Job runtimes: [`docker`]
    - Job working directory: `workdir_({your username})` (this helps us to keep the job working directories separate for each of us)
2. Save the node.
3. Create a new System Credentials entity instance (e.g., `Dev system credentials 1`).
  - System login user: `ubuntu` (or whatever system name is assigned to you for the EC2 Tapis system)
  - `System`: System above
  - `Tapis tenant`: Dev tenant above
  - Private key: *Private key* (be sure to include any new lines at the end of the key)
  - Public key: *Public key* (be sure to include any new lines at the end of the key)
4. Save.

### D. Tapis App setup
1. Tapis App requires Tapis tenant and Tapis system (refer to section B & C)
2. Create an app.
  1. Tenant: Dev tenant above
  2. Tapis ID: something like `primarysite_devenv3_web_sample_jupyter` (but use a different value!)
  3. Version: `0.1.0`
  4. Status: Enabled
  5. Summary: Jupyter Notebook
  6. App type: Web
  7. Runtime: Docker
  8. Container image source: Image URI
  9. Container image URI: `sample_jupyter`
  10. Container port: `8888`
  11. Input type: `Fixed command`
  12. Fixed command: `jupyter notebook --ip 0.0.0.0 --NotebookApp.token='' --NotebookApp.password=''`
  13. Available systems: (select the system above)
  14. Default system: (select the system above)
  15. Parameters:
    1. Environment variables:
    - `HOME='/home/jhome'`
  16. Runtime:
    1. Can be overridden by the user: `true`
  17. Save the node.

### E. Tapis Job setup
1. Tapis job requires Tapis App (refer to section D)
2. Launch the app as a job
  1. Go to the app's page
  2. Click on the `Launch` tab
  3. Select the system above
  4. Click `Launch`
3. On the job status page, it will refresh with the job status until the job is `RUNNING`.
4. Once the job is running, it will show a link to access the job's Jupyter Notebook.
5. Any files written to `/TapisOutput` inside the jupyter notebook will be written to the job's output directory in Tapis (and therefore, viewable/downloadable from Drupal once the job is complete).
6. Cancel the job.
7. Wait till the job is cancelled.
8. Go to the job's Output page.
9. This will show the output directory contents. Click on any of the files to download them.

## Access control info
Pls refer to the `TAPIS_ACCESS_CONTROL.md` file for more info on how Access control works in Tapis, in combination with the Drupal modules.