<?php

namespace Drupal\tapis_tenant;

/**
 * This file defines an interface for accessing Tapis site/tenant settings.
 *
 * @file TapisSettingsInterface.php
 */

/**
 * This interface outlines how this module.
 *
 * Interacts w/ Tapis site/tenant settings.
 */
interface TapisSettingsInterface {

  /**
   * Check whether the given Tenant setting key can be updated.
   *
   * @param string $settingKey
   *   The setting key.
   *
   * @return bool
   *   setting key's availability.
   */
  public function canUpdateTenantSetting($settingKey);

  /**
   * Validate the new tenant settings to verify if they can be saved.
   *
   * If the validation is unsuccessful, an error will be thrown.
   * Otherwise, TRUE will be returned.
   *
   * @param int $tenantId
   *   The Tapis tenant id in Drupal.
   * @param array $newSettings
   *   The settings to validate.
   *
   * @throws \Drupal\tapis_tenant\Exception\TapisTenantException
   *   When $newSettings are invalid.
   *
   * @returns
   * an associative array with the following keys:
   *          - 'is_valid' => bool
   *          - 'errors' => [[
   *              'field_name' => str,
   *              'error' => str
   *              ], ...]
   */
  public function validateTenantSettings($tenantId, array $newSettings);

}
