# Access control in Tapis

Some notes on how Access control works in Tapis and how the modules implement them.

## Systems
For systems, Tapis defines the following permissions: `READ` and `MODIFY` (which also grants the `READ` permission).

When a user creates a system, they are the owner, and they automatically have `READ` and `MODIFY` permissions for that system.

For another user to run a job on this system (regardless of whether that system uses a dynamic effective user or a static system user), that other user must also have `MODIFY` permission.

So, to support this case, we do the following:
1. Share the system publicly with the tenant
    - This gives everyone in the Tapis tenant `READ` permission to the system
2. For systems with a dynamic effective user account, we make an API call to Tapis Files (on behalf of the system's owner) to give the user trying to launch the job, the `MODIFY` permission for that system on the job working directory path.
3. For systems with a static system account, we also make an API call to Tapis Files (on behalf of the system's owner) to give the user trying to launch the job, the `MODIFY` permission for that system on the job working directory path (which MUST be defined in Drupal w/ the `${JobOwner}` macro, which ensures that despite the system using a common service account, each user in Tapis only has `MODIFY` permission to the system within their specific job working directory on that system). Another important note: All of these permissions stuff are only for the Tapis API layer, these are separate from the system's POSIX filesystem permissions, etc.

Note that we make the API calls for #2 and #3 and job submission time (and before uploading any job input files to the execution system via the Tapis Files API as part of a job submission). Note that for the file uploads, the webform submissions folder will be within the job working directory of the system, so properly making the API calls in steps #2 and #3 will ensure that this file upload operation won't error out due to invalid Tapis permissions, etc.

## Apps

For apps, Tapis defines the following permissions: `READ`, `MODIFY`, and `EXECUTE`.

Owners get all three. For someone to launch an app someone else made, they must have the `EXECUTE` permission (which also grants `READ` but not `MODIFY`).

To do this, we share the app publicly with the tenant.

Next, when we launch the app, the API calls we made in the **Systems** section above, in combination with sharing the app publicly with the tenant, will ensure that we do not get any access control/invalid permission-related issues at job runtime (e.g., like the infamous "FILES MKDIR" error in Tapis, etc.).