<?php

namespace Drupal\tapis_tenant\Controller;

use Drupal\Component\Utility\Xss;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;

/**
 * Class TapisExceptionController.
 *
 * Drupal controller that accepts a 'msg query parameter,
 * and displays a page with the title and error message.
 * This is used as a fallback for the TapisExceptionSubscriber,
 * which redirects to this controller if an unhandled Tapis exception is thrown.
 */
class TapisExceptionController extends ControllerBase {

  /**
   * Display the error message.
   *
   * @return array
   *   Return the render array.
   */
  public function display(Request $request): array {
    $error = (string) $request->query->get('msg');
    // Allow a safe subset of HTML so links/formatting render on the page.
    $safe_markup = Xss::filterAdmin($error);

    return [
      '#type' => 'container',
      'message' => [
        '#type' => 'markup',
        '#markup' => $safe_markup,
      ],
    ];
  }

}
