<?php

namespace Drupal\tapis_tenant\Exception;

/**
 * {@inheritDoc}
 */
class TapisException extends \Exception {

  /**
   * The primary exception message (nullable).
   *
   * @var string|null
   */
  protected ?string $primaryMessage;

  /**
   * Whether to reload the same page.
   *
   * @var bool
   */
  protected bool $reloadSamePage;

  /**
   * Constructs a new TapisException.
   *
   * @param string $message
   *   The exception message.
   * @param int $code
   *   The exception code.
   * @param \Throwable|null $previous
   *   The previous exception used for exception chaining.
   * @param string|null $primaryMessage
   *   Optional “primary” message.
   * @param bool $reload_same_page
   *   Whether to reload the same page.
   */
  public function __construct(
    string $message,
    int $code = 0,
    \Throwable $previous = NULL,
    ?string $primaryMessage = NULL,
    bool $reload_same_page = FALSE
  ) {
    parent::__construct($message, $code, $previous);
    $this->primaryMessage = $primaryMessage;
    $this->reloadSamePage = $reload_same_page;
  }

  /**
   * Returns the primary exception message, if any.
   *
   * @return string|null
   *   The exception’s primary message or NULL.
   */
  public function getPrimaryMessage(): ?string {
    return $this->primaryMessage;
  }

  /**
   * Sets the primary exception message (or NULL to unset).
   *
   * @param string|null $primaryMessage
   *   The new primary exception message or NULL.
   */
  public function setPrimaryMessage(?string $primaryMessage): void {
    $this->primaryMessage = $primaryMessage;
  }

  /**
   * Sets whether to reload the same page.
   *
   * @param bool $reloadSamePage
   *   TRUE if the same page should be reloaded; otherwise FALSE.
   */
  public function setReloadSamePage(bool $reloadSamePage): void {
    $this->reloadSamePage = $reloadSamePage;
  }

  /**
   * Indicates whether the same page should be reloaded.
   *
   * @return bool
   *   TRUE if the same page should be reloaded, otherwise FALSE.
   */
  public function shouldReloadSamePage(): bool {
    return $this->reloadSamePage;
  }

}
