<?php

namespace Drupal\tapis_tenant\Exception;

/**
 * Tapis Tenant Exception.
 *
 * This exception is thrown when there is an error with the Tapis Tenant module.
 */
class TapisTenantException extends TapisException {

  /**
   * Constructs a new TapisTenantException.
   *
   * @param string $message
   *   The exception message.
   * @param int $code
   *   The exception code.
   * @param \Throwable|null $previous
   *   The previous exception used for the exception chaining.
   */
  public function __construct($message, $code = 0, \Throwable $previous = NULL) {
    $message = "Tapis Tenant Exception: " . $message;
    parent::__construct($message, $code, $previous);
  }

}
