## INTRODUCTION

The Taxonomy Machine Name Field Formatter module provides a field formatter for
taxonomy reference fields that outputs term properties in a list of separate
fields per term.

Note from the author:

- It’s another one of those "scratch my own itch" modules.
- I created this module to get results quickly and because I was unsure about
  the current maintenance state of the parent Taxonomy Machine Name project.
- The end goal is to contribute this formatter back and merge it into the parent
  module, if the maintainers are interested in adopting and maintaining this
  code.

Primary use cases:

- Expose raw string-based values to front-end consumers or APIs as predictable
  key/value data.

## REQUIREMENTS

- Drupal >=10.x
- [Taxonomy Machine Name](https://www.drupal.org/project/taxonomy_machine_name)

## INSTALLATION

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.

## CONFIGURATION

- Add or edit an entity display that includes a taxonomy term reference field.
- Choose the `Machine name with Label` output
- Configure options:
    - Raw mode, no markup just plain key/value items
    - Link label to the referenced entity
    - Link and label as seperated items
- Save the display settings.

The option Link and label as seperated items is only available if you turned
Link label to the referenced entity on.

## Output

### Raw mode

In Raw mode the variables are send without any markup helper to your template.
You must handle the processing yourself in twig or else you will end up with a
`InvalidArgumentException: "machine_name" is an invalid render array key.`
error!

In raw mode the variables per term passed to the template are always like this

```
Array (
    [machine_name] => "value"
    [label] => "value"
)
```

Using raw mode you can use the value of a field directly in a twig template by
using the [twig_field_value](https://www.drupal.org/project/twig_field_value)
module

```
    {% set checked = {} %}
    {% for checked in field_checkable|field_value %}
        {% set checked = checked|merge({(facility.machine_name ): facility.label}) %}
    {% endfor %}
```

### Renderable mode

Without raw mode, the variables per term passed to the template are a
combination of the following fields

```
Array
(
    [machine_name] => Array
        (
            [#markup] => {{ value }}
        )

    [link] => Array
        (
            [#markup] => i{{ value }}
        )
    [label] => Array
        (
           [#markup] => i{{ value }}
        )
```

If you required the label to be a link you will get this instead of the label
above.

```
    [label] => Array
        (
            [#type] => link
            [#title] => Some term
            [#url] => {\Drupal\Core\Url}
            [#options] => Array 
                (
                    [entity_type] => taxonomy_term
                    [entity] => {\Drupal\Core\Entity\Term}
                    [language] => {\Drupal\Core\Language\Language}
                )
        )        
)
```
