# INTRODUCTION

The module is smart, lightweight and powerful. It creates a numbered index or address from the hierarchical structure of a taxonomy vocabulary, based on the weight property of terms, can thus be used for sorting and to create a unique and stable reference, e.g. "Chapter 2, Section 12, Sentence A".

Entities of any types (e.g. Nodes) can be integrated in this structure if they refer to a taxonomy term of this vocabulary. The module provides a field type that can be applied to any entity type. It saves just a weight (integer) number. It can be connected to another (entity reference) field of the same entity, from which it receives the required information on how to build its index number.

**The primary use case for this module is:**

Structured text collections, which should have stable referencing, e.g. for citation.

Such as:

- Contracts (as it is built for the RulesFinder distribution)
- Books
- Directories

## HOW IT WORKS

As already mentioned: each entity just has a weight field, where a primitive integer is saved. (We changed the label of the field to "Ordinal number" and limited the range of values to 0 <= w <= 999.) The formatted address is just the output of the field formatter. Whenever the field is called to be displayed (e.g. in an entity view mode) the (referenced) term is looked up and a kind of IP-address is built from its weight and the weight from its parents:

```
2.3.1 => for terms
2.3.1:4 => for nodes (or other entities)
```

The '2.3.1' part is the term address where

- '2' is the weight from the root term
- '3' the weight from the 2nd level term
- '1' is the weight of the current (referenced) term
- '4' (divided by a colon ':') is the node (or entity) weight and will be handled different.

From here we parse the address through different string formatters, that are stored in the config (for terms in the vocabulary settings, for all other entities in the field settings).

1. parser: for each term level and each entity field you can select the index format ('123', 'abc', 'ABC', 'iii', 'III' or greek 'αβγ', 'ΑΒΓ')
2. parser: String formatter to embed the indexes into a readable address format e.g. 'Chap. 2, sec. C, para. I, art. a'. In the formatter you can select between four different (full customizable) display modes:
   - item (without taxonomy path, e.g. for lists: e.g. 'article a', or 'para. 2')
   - short (e.g. '2.C-I, a')
   - medium (e.g. 'Chap. 2, sec. C, para. I, art. a')
   - long (e.g. 'Chapter 2, section C, paragraph I, article a')

## REQUIREMENTS

Cores Taxonomy module

## INSTALLATION

Install as you would normally install a contributed Drupal module.
See: https://www.drupal.org/node/895232 for further information.

```$ composer require drupal/taxonomy_ordinal:^1.0```

## CONFIGURATION
- If you have no Taxonomy Vocabulary yet, go to ```/admin/structure/taxonomy``` and add a new one. And add some terms in a nested structure to see the effects of the Taxonomy Ordinal module.
- If you have enabled the module go to ```/admin/config/content/taxonomy-ordinal``` or in the menu [Configuration => Content authoring => Taxonomy Ordinal]
- Enable the taxonomy vocabulary that you want to use to structure your content. And click "Save configuration".
- Clear the cache (full)
- Go to the enabled vocabulary config page: e.g. ```/admin/structure/taxonomy/manage/{sections}``` where {sections is the id of your vocab.}
- Here you should see a new section "Taxonomy Ordinal" where you can edit the formatters. In the formatters special chars are used:
  - Pipe '|' to separate the term (parent/children) levels. (You don't need to configure all levels. When no formatter is present for deeper levels, the ordinal number is appended with a leading dot '.')
  - Placeholder '%on' where the ordinal number is injected.
- IMPORTANT: You must save the config at least once, even when are ok with the default values, because they have not been written into the third party settings of the section.
- Now move to the "Manage display" tab of your vocabulary.
- Move the Field "Ordinal number" (the (formerly hidden) "weight" field) into the visible region. Click the gear to adjust the display style. (Repeat this for every view mode, where you want to display the field.)
- When everything is saved, the taxonomy terms should now display an ordinal structure and you can modify their ordinal number in the terms edit form in the section "Relation".

### Now we want to extend the structure upon nodes (or other entities) that refer to the terms.
- Open the "Manage Fields" section of your node type ```/admin/structure/types/manage/{article}/fields``` where {article} is the placeholder for your node bundle.
- If you have no entity reference field here, that refers to terms of the vocabulary above, then add one. It should have a cardinality of "1" (not multiple values).
- Add also a new field "Taxonomy Ordinal".
- IMPORTANT: If you want to add other node bundles into the ordinal structure YOU SHOULD NOT RE-USE this field, because if you do so you cannot adjust the formatters individual for each node type. We put the config for the formatters into the field config and not in the field-formatter config, to guaranty, that the number format ('abc' or '123') is the same for all view modes.
- In the field settings of the new taxonomy_ordinal field you have to select in the setting "taxonomy" the entity_reference field from above, that refers to terms of the vocabulary we enabled above.
- Then configure the formatters as we did for the taxonomy vocabulary above. Good example values are:
  - Number format: 'abc'
  - Item formatter: '(%on)'
  - Short/Medium/Long formatter: ', (%on)' The leading comma is because it will be appended to the taxonomy path.
- Now go the manage display tab of your node type and configure the formatter, as we already did for the taxonomy terms.
- And that's it.

The REAL content management begins NOW. ;-)

## KNOWN ISSUES

For vocabularies enabled in "Taxonomy Ordinal":

1. We overwrite the vocabulary edit form. If another module is doing the same thing there will be a conflict. You might not see the "Taxonomy Ordinal" block for the formatters. (Please write a ticket and inform us about conflicting modules)
2. From the taxonomy term LIST, we removed the weight column, the drag&drop behavior and suppressed all changes of the weight field initiated from here, because it destroys the ordinal structure. The weight field can only be edited in the term edit form.

## MAINTAINERS

Current maintainers for Drupal 10:

- Joachim Feltkamp (JFeltkamp) - https://www.drupal.org/u/jfeltkamp

