<?php

declare(strict_types=1);

namespace Drupal\taxonomy_ordinal\Plugin\Field\FieldWidget;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\Plugin\Field\FieldWidget\NumberWidget;
use Drupal\Core\Form\FormStateInterface;

/**
 * Widget for the 'taxonomy_ordinal' field type.
 *
 * @FieldWidget(
 *   id = "taxonomy_ordinal_widget",
 *   label = @Translation("Taxonomy Ordinal"),
 *   field_types = {
 *     "taxonomy_ordinal"
 *   }
 * )
 */
class TaxonomyOrdinalWidget extends NumberWidget {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state): array {
    // Reuse core number widget behavior but enforce min/max from settings.
    $element = parent::formElement($items, $delta, $element, $form, $form_state);

    $settings = $this->getFieldSettings();
    $element['value']['#min'] = 0;
    $element['value']['#step'] = 1;
    if (!empty($settings['max'])) {
      $element['value']['#max'] = (int) $settings['max'];
    }

    // Accessibility: explicit title if none provided by formatter.
    if (!isset($element['value']['#title'])) {
      $element['value']['#title'] = $this->t('Ordinal');
    }

    return $element;
  }

}
