# Taxonomy Overview Drupal Module

## Overview

**Taxonomy Overview** is a Drupal module designed to help site administrators and editors manage, analyze, and maintain taxonomy terms more efficiently. It provides enhanced views, grouping, merging, and normalization tools for taxonomy vocabularies, making it easier to keep your site's tags and categories organized and consistent.

---

## Features

- **Taxonomy Term Overview:** View and analyze all terms in a vocabulary, including usage statistics and relationships.
- **Term Grouping:** Group terms by various criteria for easier management and bulk actions.
- **Term Merging:** Merge duplicate or similar terms, consolidating content references and cleaning up vocabularies.
- **Term Normalization:** Normalize term data for consistency (e.g., case, formatting).
- **Custom Forms:** User-friendly forms for overview, grouping, and merging operations.
- **Custom Controllers:** Efficient backend logic for displaying and processing taxonomy data.
- **Custom Styles:** Enhanced UI with custom CSS for forms and overview pages.

---

## Folder Structure

```
taxonomy_overview/
├── composer.json
├── LICENSE.txt
├── taxonomy_overview.info.yml
├── taxonomy_overview.libraries.yml
├── taxonomy_overview.links.task.yml
├── taxonomy_overview.routing.yml
├── css/
│   ├── form.css
│   └── style.css
└── src/
    ├── TagsOverviewTermNormalizer.php           # Logic for normalizing terms
    ├── Controller/
    │   ├── TagsOverviewController.php           # Main overview controller
    │   └── TagsOverviewTermGroupController.php  # Controller for term grouping
    └── Form/
        ├── TagsOverviewForm.php                 # Overview form
        └── TagsOverviewTermMergeForm.php        # Form for merging terms
```

---

## Main Functionalities

### 1. Taxonomy Term Overview

- **TagsOverviewController.php & TagsOverviewForm.php:**  
  Display a comprehensive overview of all terms in a selected vocabulary. Includes term usage counts, relationships, and other metadata to help identify duplicates, unused terms, or organizational issues.

### 2. Term Grouping

- **TagsOverviewTermGroupController.php:**  
  Allows administrators to group terms by criteria such as prefix, usage, or custom attributes. Facilitates bulk actions and easier navigation of large vocabularies.

### 3. Term Merging

- **TagsOverviewTermMergeForm.php:**  
  Provides a form for merging duplicate or similar terms. Ensures all content referencing the merged terms is updated to the target term, and removes redundant entries.

### 4. Term Normalization

- **TagsOverviewTermNormalizer.php:**  
  Contains logic for normalizing term data, such as converting to lowercase, trimming whitespace, or applying custom formatting rules. Helps maintain consistency across vocabularies.

### 5. Custom Styling

- **css/form.css & css/style.css:**  
  Enhance the appearance and usability of overview, grouping, and merge forms/pages.

---

## Key Classes & Files

- **TagsOverviewController.php:** Main controller for displaying taxonomy term overviews.
- **TagsOverviewTermGroupController.php:** Controller for grouping terms.
- **TagsOverviewForm.php:** Form for overview actions and filtering.
- **TagsOverviewTermMergeForm.php:** Form for merging terms.
- **TagsOverviewTermNormalizer.php:** Utility for term normalization.

---

## Usage

### Viewing Taxonomy Overview

1. Navigate to the Taxonomy Overview page from the Drupal admin menu.
2. Select a vocabulary to view all terms, usage statistics, and relationships.
3. Use filters and sorting to analyze terms.

### Grouping Terms

1. Access the term grouping interface.
2. Choose grouping criteria (e.g., prefix, usage).
3. View grouped terms and perform bulk actions as needed.

### Merging Terms

1. Select terms to merge using the merge form.
2. Choose the target term to retain.
3. Submit the form to update all references and remove duplicates.

### Normalizing Terms

- Normalization is performed automatically or via admin actions, ensuring term data remains consistent.

---

## Requirements

- Drupal 9 or 10
- PHP 7.4+
- Appropriate permissions for managing taxonomy terms

---

## Extending

- Add new grouping or normalization criteria by extending the relevant controllers or normalizer class.
- Customize UI by editing the CSS files.

---

## License

See `LICENSE.txt`.

---

## Support

For issues or feature requests, open an issue in your repository or contact the maintainer.
