<?php

namespace Drupal\taxonomy_overview\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\taxonomy\Entity\Term;
use Drupal\taxonomy_overview\TagsOverviewTermNormalizer;
use Drupal\Core\Render\Markup;
use Drupal\Core\Url;
use Drupal\Core\Link;

/**
 *
 */
class TagsOverviewTermGroupController extends ControllerBase {

  /**
   *
   */
  public function groupTerms() {
    $terms = [];

    $route_match = \Drupal::routeMatch();
    $vocabulary = $route_match->getParameter('taxonomy_vocabulary');

    $tids = \Drupal::entityQuery('taxonomy_term')
      ->accessCheck(FALSE)
      ->condition('vid', $vocabulary)
      ->execute();
    $loaded_terms = Term::loadMultiple($tids);
    foreach ($loaded_terms as $term) {
      $terms[$term->id()] = $term->label();
    }

    $normalizer = new TagsOverviewTermNormalizer();
    $groups = $normalizer->groupSimilarTerms($terms);

    $rows = [];
    foreach ($groups as $groupKey => $groupTerms) {
      $links = [];
      $tids = array_keys($groupTerms);
      foreach ($groupTerms as $tid => $label) {
        $url = Term::load($tid)->toUrl()->toString();
        $links[] = "<a href='{$url}' target='_blank'>{$label}</a>";
      }
      $merge_url = Url::fromRoute('taxonomy_overview.group_similar.merge_form', [
        'term_ids' => implode(',', $tids),
        'taxonomy_vocabulary' => $vocabulary,
      ]);
      $merge_url->setOptions([
        'attributes' => [
          'class' => ['button', 'button--primary'],
        ],
      ]);

      $merge_link = Link::fromTextAndUrl('Merge', $merge_url)->toString();
      if (count($tids) > 1) {
        $rows[] = [
          'data' => [
            Markup::create(implode(', ', $links)),
            [
              'data' => $merge_link,
            ],
          ],
        ];
      }
    }

    return [
      '#type' => 'table',
      '#header' => [
        'Grouped Similar Terms',
        'Operations',
      ],
      '#rows' => $rows,
      '#markup' => '',
      '#title' => $this->t('Grouped Similar Taxonomy Terms'),
      '#attached' => [
        'library' => [],
      ],
    ];
  }

}
