<?php

namespace Drupal\taxonomy_overview\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 *
 */
class TagsOverviewForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'taxonomy_overview_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $search_term = \Drupal::request()->query->get('search', '');
    $sort_by = \Drupal::request()->query->get('sort_by', 'name');
    $sort_order = \Drupal::request()->query->get('sort_order', 'desc');
    $random_bg = \Drupal::request()->query->get('random_bg') == 1;

    if (!\Drupal::routeMatch()->getParameter('taxonomy_term')) {
      $form = [
        '#type' => 'form',
        '#method' => 'get',
        'search_input' => [
          '#type' => 'textfield',
          '#title' => $this->t('Search'),
          '#value' => $search_term,
          '#attributes' => [
            'name' => 'search',
            'placeholder' => $this->t('Enter tag name'),
            'style' => 'display:flex',
          ],
        ],
        'sort_by' => [
          '#type' => 'hidden',
          '#value' => $sort_by,
          '#attributes' => [
            'name' => 'sort_by',
          ],
        ],
        'sort_order' => [
          '#type' => 'hidden',
          '#value' => $sort_order,
          '#attributes' => [
            'name' => 'sort_order',
          ],
        ],
        'submit_button' => [
          '#type' => 'submit',
          '#value' => $this->t('Search'),
        ],
      ];
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // Handle form submission.
  }

}
