<?php

namespace Drupal\taxonomy_overview\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

/**
 * Substitui o form padrão de overview de termos.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    if ($route = $collection->get('entity.taxonomy_vocabulary.overview_form')) {
      $route->setDefault('_form', '\Drupal\taxonomy_overview\Form\OverviewTermsFiltered');
    }
  }

}
