<?php

namespace Drupal\taxonomy_overview;

use Drupal\taxonomy\VocabularyListBuilder as CoreVocabularyListBuilder;

/**
 * Provides a list controller for taxonomy vocabularies with filtering.
 */
class VocabularyListBuilder extends CoreVocabularyListBuilder {

  /**
   * {@inheritdoc}
   */
  public function render() {
    // Add our filter form on top of the default table.
    $build['filter_form'] = \Drupal::formBuilder()->getForm('\Drupal\taxonomy_overview\Form\VocabularyFilterForm');
    $build += parent::render();
    return $build;
  }

  /**
   * {@inheritdoc}
   */
  protected function getEntityIds() {
    $query = $this->getStorage()->getQuery()->sort($this->entityType->getKey('id'));

    // Add filter from tempstore.
    $tempstore = \Drupal::service('tempstore.private')->get('taxonomy_overview');
    $filter = $tempstore->get('filter_name');

    if (!empty($filter)) {
      $filter = trim($filter);
      // Use a supported operator for config/entity queries.
      $query->condition('name', $filter, 'CONTAINS');
    }

    return $query->execute();
  }

}
