<?php

namespace Drupal\taxonomy_term_config_groups\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBundleBase;

/**
 * Defines the Taxonomy group type configuration entity (bundle).
 *
 * Bundles are intended to be managed programmatically; no admin UI is exposed.
 *
 * @ConfigEntityType(
 *   id = "taxonomy_group_type",
 *   label = @Translation("Taxonomy group type"),
 *   label_collection = @Translation("Taxonomy group types"),
 *   config_prefix = "taxonomy_group_type",
 *   handlers = {
 *     "list_builder" = "Drupal\taxonomy_term_config_groups\TaxonomyGroupTypeListBuilder",
 *     "access" = "Drupal\taxonomy_term_config_groups\TaxonomyGroupTypeAccessControlHandler",
 *     "form" = {
 *       "add" = "Drupal\Core\Entity\EntityForm",
 *       "edit" = "Drupal\Core\Entity\EntityForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm"
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider"
 *     }
 *   },
 *   admin_permission = "administer taxonomy",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid"
 *   },
 *   links = {
 *     "edit-form" = "/admin/structure/taxonomy-groups/types/{taxonomy_group_type}/edit",
 *     "delete-form" = "/admin/structure/taxonomy-groups/types/{taxonomy_group_type}/delete"
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "uuid"
 *   },
 *   bundle_of = "taxonomy_group"
 * )
 */
class TaxonomyGroupType extends ConfigEntityBundleBase {

  /**
   * The machine name of the bundle.
   *
   * @var string
   */
  protected $id;

  /**
   * The human-readable label of the bundle.
   *
   * @var string
   */
  protected $label;

  /**
   * {@inheritdoc}
   */
  public function calculateDependencies() {
    parent::calculateDependencies();

    // If this bundle follows the pattern 'vocab_<vid>', declare a config
    // dependency on the related vocabulary so that when a vocabulary is being
    // deleted, this bundle appears in the "Configuration deletions" section.
    $id = (string) $this->id();
    $prefix = 'vocab_';
    if (str_starts_with($id, $prefix)) {
      $vid = substr($id, strlen($prefix));
      if ($vid !== '') {
        $this->addDependency('config', "taxonomy.vocabulary.$vid");
      }
    }

    return $this;
  }

}
