(function (Drupal, once) {
  'use strict';

    /**
   * Initialize taxonomy usage tabs.
   */
  Drupal.behaviors.taxonomyUsageTabs = {
    attach: function (context, settings) {
      // Handle both initial page load and AJAX contexts
      once('taxonomy-usage-tabs', '.taxonomy-usage-tabs', context).forEach(function (tabContainer) {
        initializeTabs(tabContainer);
      });

      // Also handle cases where tabs might be in modals or AJAX content
      once('taxonomy-usage-tabs-modal', '.ui-dialog .taxonomy-usage-tabs, .modal .taxonomy-usage-tabs, .taxonomy-manager-delete-form .taxonomy-usage-tabs', context).forEach(function (tabContainer) {
        initializeTabs(tabContainer);
      });

      // Force initialization after a short delay for AJAX content
      setTimeout(function () {
        const newTabs = context.querySelectorAll('.taxonomy-usage-tabs:not([data-taxonomy-usage-tabs-processed])');
        newTabs.forEach(function (tabContainer) {
          tabContainer.setAttribute('data-taxonomy-usage-tabs-processed', 'true');
          initializeTabs(tabContainer);
        });
      }, 100);
    }
  };

  /**
   * Initialize tab functionality for a container.
   */
  function initializeTabs(tabContainer) {
    const tabLinks = tabContainer.querySelectorAll('.taxonomy-usage-tab-link');
    const tabPanes = tabContainer.querySelectorAll('.taxonomy-usage-tab-pane');

    if (tabLinks.length === 0 || tabPanes.length === 0) {
      return;
    }

    tabLinks.forEach(function (link) {
      link.addEventListener('click', function (e) {
        e.preventDefault();
        e.stopPropagation();

        const targetId = this.getAttribute('href').substring(1);
        const targetPane = tabContainer.querySelector('#' + targetId);

        if (targetPane) {
          // Remove active class from all tabs and panes in this container
          tabContainer.querySelectorAll('.taxonomy-usage-tab-item').forEach(function (tabItem) {
            tabItem.classList.remove('active');
          });

          tabContainer.querySelectorAll('.taxonomy-usage-tab-pane').forEach(function (pane) {
            pane.classList.remove('active');
          });

          // Add active class to clicked tab and corresponding pane
          this.parentElement.classList.add('active');
          targetPane.classList.add('active');
        }
      });
    });
  }

  // Also handle AJAX command responses
  Drupal.AjaxCommands.prototype.taxonomyUsageTabsInit = function (ajax, response, status) {
    const context = response.selector ? document.querySelector(response.selector) : document;
    Drupal.behaviors.taxonomyUsageTabs.attach(context, drupalSettings);
  };

})(Drupal, once);
