<?php

namespace Drupal\teamleader_contact\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\teamleader\TeamleaderApiServiceInterface;

/**
 * Implements form-related hooks for teamleader_contact module.
 */
class FormHooks {

  /**
   * Construct a new FormHooks object.
   *
   * @param \Drupal\teamleader\TeamleaderApiServiceInterface $teamleaderApi
   *   The Teamleader API service.
   */
  public function __construct(protected TeamleaderApiServiceInterface $teamleaderApi) {}

  /**
   * Implements hook_form_FORM_ID_alter() for contact_form_form().
   */
  #[Hook('form_contact_message_form_alter')]
  public function teamleaderContactFormMessageAlter(&$form, &$form_state, $form_id): void {
    $form['actions']['submit']['#submit'][] = [$this->teamleaderApi, 'addContactToTeamleader'];
  }

}
