<?php

namespace Drupal\telega_bot\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the bot entity edit forms.
 */
class TelegaBotForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {

    $entity = $this->getEntity();
    $result = $entity->save();
    $link = $entity->toLink($this->t('View'))->toRenderable();

    $message_arguments = ['%label' => $this->entity->label()];
    $logger_arguments = $message_arguments + [
      'link' => \Drupal::service('renderer')->render($link),
    ];

    if ($result == SAVED_NEW) {
      $this->messenger()->addStatus($this->t('New bot %label has been created.', $message_arguments));
      $this->logger('telega_bot')->notice('Created new bot %label', $logger_arguments);
    }
    else {
      $this->messenger()->addStatus($this->t('The bot %label has been updated.', $message_arguments));
      $this->logger('telega_bot')->notice('Updated new bot %label.', $logger_arguments);
    }

    $form_state->setRedirect('entity.telega_bot.canonical', ['telega_bot' => $entity->id()]);
  }

}
