<?php

namespace Drupal\telephone_advanced;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use libphonenumber\PhoneNumberFormat;

/**
 * Provides the telephone number formats.
 */
class TelephoneFormats {

  /**
   * Get all format labels.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup[]
   *   The format labels.
   */
  public static function getLabels(): array {
    return [
      self::getId(PhoneNumberFormat::NATIONAL) => t('National'),
      self::getId(PhoneNumberFormat::INTERNATIONAL) => t('International'),
      self::getId(PhoneNumberFormat::E164) => t('E164'),
      self::getId(PhoneNumberFormat::RFC3966) => t('RFC 3966'),
    ];
  }

  /**
   * Get the ID of a format.
   *
   * @param \libphonenumber\PhoneNumberFormat|int $format
   *   The format as enum or ID.
   *
   * @return int
   *   The format ID or NULL if unknown.
   */
  public static function getId(PhoneNumberFormat|int $format): int {
    if ($format instanceof PhoneNumberFormat) {
      return $format->value;
    }

    return (int) $format;
  }

  /**
   * Get the label of a format.
   *
   * @param \libphonenumber\PhoneNumberFormat|int $format
   *   The format as enum or ID.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup|null
   *   The format label or NULL if unknown.
   */
  public static function getLabel(PhoneNumberFormat|int $format): ?TranslatableMarkup {
    $format = self::getId($format);
    $labels = static::getLabels();

    return $labels[$format] ?? NULL;
  }

}
