<?php

namespace Drupal\telephone_advanced;

use libphonenumber\PhoneNumber;
use libphonenumber\PhoneNumberFormat;
use libphonenumber\PhoneNumberUtil;

/**
 * Provides the telephone formatter.
 */
class TelephoneFormatter implements TelephoneFormatterInterface {

  /**
   * Class constructor.
   *
   * @param \Drupal\telephone_advanced\TelephoneParserInterface $telephoneParser
   *   The telephone parser.
   */
  public function __construct(
    protected readonly TelephoneParserInterface $telephoneParser,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function format(PhoneNumber|string $number, PhoneNumberFormat|int $format, ?string $default_country = NULL) {
    if (!$number instanceof PhoneNumber) {
      $number = $this->telephoneParser->parse($number, $default_country);
    }

    if (!$format instanceof PhoneNumberFormat && method_exists(PhoneNumberFormat::class, 'tryFrom')) {
      $format = PhoneNumberFormat::tryFrom($format);
    }

    return PhoneNumberUtil::getInstance()->format($number, $format);
  }

}
