<?php

namespace Drupal\telephone_advanced;

use libphonenumber\PhoneNumber;
use libphonenumber\PhoneNumberFormat;

/**
 * Interface for the telephone formatter service.
 */
interface TelephoneFormatterInterface {

  /**
   * Format a telephone number.
   *
   * @param \libphonenumber\PhoneNumber|string $number
   *   The telephone number.
   * @param \libphonenumber\PhoneNumberFormat|int $format
   *   The desired format.
   * @param string|null $default_country
   *   The default country code. Can be NULL when $number is a PhoneNumber object
   *   or if it's guaranteed to start with a country calling code.
   *
   * @return string
   *   The formatted telephone number.
   */
  public function format(PhoneNumber|string $number, PhoneNumberFormat|int $format, ?string $default_country = NULL);

}
