<?php

namespace Drupal\telephone_advanced;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use libphonenumber\PhoneNumberType;

/**
 * Provides the telephone number types.
 */
class TelephoneTypes {

  /**
   * Get all type labels.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup[]
   *   The type labels.
   */
  public static function getLabels(): array {
    return [
      self::getId(PhoneNumberType::FIXED_LINE) => t('Fixed line'),
      self::getId(PhoneNumberType::MOBILE) => t('Mobile'),
      self::getId(PhoneNumberType::PAGER) => t('Pager'),
      self::getId(PhoneNumberType::VOIP) => t('VOIP'),
      self::getId(PhoneNumberType::PERSONAL_NUMBER) => t('Personal number'),
      self::getId(PhoneNumberType::UAN) => t('UAN'),
      self::getId(PhoneNumberType::TOLL_FREE) => t('Toll free'),
      self::getId(PhoneNumberType::STANDARD_RATE) => t('Standard rate'),
      self::getId(PhoneNumberType::SHARED_COST) => t('Shared cost'),
      self::getId(PhoneNumberType::PREMIUM_RATE) => t('Premium rate'),
      self::getId(PhoneNumberType::VOICEMAIL) => t('Voicemail'),
      self::getId(PhoneNumberType::SHORT_CODE) => t('Short code'),
      self::getId(PhoneNumberType::EMERGENCY) => t('Emergency'),
    ];
  }

  /**
   * Get the ID of a type.
   *
   * @param \libphonenumber\PhoneNumberType|int $type
   *   The type as enum or ID.
   *
   * @return int
   *   The type ID or NULL if unknown.
   */
  public static function getId(PhoneNumberType|int $type): int {
    if ($type instanceof PhoneNumberType) {
      return $type->value;
    }

    return (int) $type;
  }

  /**
   * Get the label of a type.
   *
   * @param \libphonenumber\PhoneNumberType|int $type
   *   The type as enum or ID.
   *
   * @return \Drupal\Core\StringTranslation\TranslatableMarkup|null
   *   The type label or NULL if unknown.
   */
  public static function getLabel(PhoneNumberType|int $type): ?TranslatableMarkup {
    $type = self::getId($type);
    $labels = static::getLabels();

    return $labels[$type] ?? NULL;
  }

}
