/**
 * @file
 */

(function (Drupal, once) {
  Drupal.behaviors.tencentcloudCaptchaPrepare = {
    attach: function (context, settings) {
      once('tencentcloud-captcha-prepare', '#tencentcloud-captcha', context).forEach(function(captchaBtn) {
        // Disable or hide submit button until captcha is ready, actions.js will re-enable it.
        let btnSubmit = captchaBtn.closest('form').querySelector('#edit-submit');
        if (btnSubmit) {
          btnSubmit.setAttribute('disabled', 'disabled');
        }
        
        let checkReadyState = setInterval(function () {
          if (document.readyState === "complete") {
            clearInterval(checkReadyState);
            // Enable/show submit button after page is ready.
            if (btnSubmit) {
              btnSubmit.removeAttribute('disabled');
            }
          }
        }, 100);
      });
    }
  };
})(Drupal, once);
