# Term Delete Protection

The Term Delete Protection module prevents taxonomy terms from being deleted
when they are referenced by content or other entities. This helps maintain data
integrity by ensuring that referenced terms cannot be accidentally removed.

The module automatically detects when terms are in use and:
- Removes the delete operation from term listing pages
- Blocks deletion attempts via the delete form
- Shows detailed warnings about which content is using the term
- Protects parent terms if any descendant terms are referenced

For a full description of the module, visit the
[project page](https://www.drupal.org/project/term_delete_protection).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/term_delete_protection).


## Table of contents

- Requirements
- Recommended modules
- Installation
- Configuration
- Features
- How it works
- Testing
- Troubleshooting
- FAQ
- Maintainers


## Requirements

This module requires the following modules:

- Taxonomy (Drupal core)

Optional entity type support:
- Commerce Product module (if protecting commerce products)
- Paragraphs module (if protecting paragraphs)


## Recommended modules

- [Markdown filter](https://www.drupal.org/project/markdown):
  When enabled, display of the project's README.md help will be rendered
  with markdown.


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

1. Navigate to Administration > Structure > Taxonomy
1. Click "Edit" on the vocabulary you want to protect
1. Expand the "Term Delete Protection" section
1. Select which entity types to check for references:
   - Enable term delete protection for nodes (always available)
   - Enable term delete protection for commerce products (if Commerce installed)
   - Enable term delete protection for paragraphs (if Paragraphs installed)
1. Save the vocabulary

The module will now protect terms in that vocabulary from deletion if they are
referenced by the selected entity types.


## Features

### Generic entity support

- **Dynamic field discovery**: Automatically finds all taxonomy reference fields
  for any entity type
- **Node support**: Works with ANY content type (article, page, custom types)
- **Commerce product support**: Protects terms referenced by products
- **Paragraph support**: Shows parent entities that contain paragraphs
  referencing the term

### Recursive protection

- **Hierarchical checking**: Protects parent terms if any descendant terms
  (children, grandchildren, etc.) are referenced by content
- **Infinite loop prevention**: Safely handles complex term hierarchies

### User interface

- **Operation removal**: Delete operations are automatically hidden from term
  listing pages for protected terms
- **Deletion blocking**: Prevents deletion via the delete form with a clear
  error message
- **Detailed warnings**: When editing a term, shows which content is using it:
  - Grouped by entity type (Nodes, Commerce Products, Paragraphs)
  - Links to the content for easy access
  - Shows content type/bundle information
  - Limits to 5 items per term to prevent UI overload
  - Most recent content listed first

### Configuration flexibility

- **Per-vocabulary settings**: Enable protection only for specific vocabularies
- **Multi-entity type support**: Choose which entity types to check for each
  vocabulary
- **Conditional UI**: Checkboxes only appear if the relevant module is installed


## How it works

The module uses multiple layers of protection:

1. **Event Subscriber**: Intercepts delete form requests and blocks access if
   term is referenced
1. **Operation Alter**: Removes delete links from term listing pages
1. **Form Alter**: Adds warning messages to term edit forms and removes delete
   button
1. **Service Layer**: Provides methods to check term references across multiple
   entity types

The reference checking:
- Dynamically discovers all taxonomy reference fields via EntityFieldManager
- Queries entities for references to the term and its descendants
- Handles special cases (e.g., paragraphs showing parent entities)
- Uses dependency injection for proper Drupal architecture


## Testing

This module includes comprehensive automated tests:

### Running tests locally

To run the tests locally using DDEV:

```bash
# Run Kernel tests
ddev exec vendor/bin/phpunit -c web/core --group term_delete_protection web/modules/custom/term_delete_protection/tests/src/Kernel

# Run Functional tests
ddev exec vendor/bin/phpunit -c web/core --group term_delete_protection web/modules/custom/term_delete_protection/tests/src/Functional

# Run all tests for the module
ddev exec vendor/bin/phpunit -c web/core --group term_delete_protection web/modules/custom/term_delete_protection
```

### Test coverage

**Kernel tests** (`tests/src/Kernel/TermReferenceCheckerTest.php`):
- Tests unreferenced term detection
- Tests referenced term detection
- Verifies unpublished nodes don't prevent deletion
- Tests recursive descendant term protection
- Validates configuration-based protection

**Functional tests** (`tests/src/Functional/TermDeleteProtectionTest.php`):
- Tests vocabulary configuration form
- Tests delete operation removal from UI
- Tests deletion blocking via delete form
- Tests warning messages on term edit forms
- Verifies unreferenced terms can be deleted

### Continuous Integration

The module includes `.gitlab-ci.yml` for automated testing on Drupal.org GitLab:
- Code quality checks with PHP_CodeSniffer
- PHPUnit tests run automatically on push
- Tests against Drupal core 10.3.x with PHP 8.1

### Contributing tests

When contributing code, please:
1. Add test coverage for new features
1. Ensure all existing tests pass
1. Follow Drupal coding standards
1. Document test scenarios in docblocks


## Troubleshooting

**Problem**: Delete protection is not working for a vocabulary

**Solution**: Make sure you have:
- Enabled protection in the vocabulary settings
- Selected at least one entity type to check
- Cleared the Drupal cache after configuration changes

**Problem**: Getting errors when viewing terms with paragraph references

**Solution**: This was fixed in version 1.1. The module now properly shows the
parent entities (nodes) that contain the paragraphs, rather than trying to link
directly to paragraph entities.

**Problem**: Protection is too aggressive - term can't be deleted even when
not used

**Solution**: Check if the term has descendant terms that are being used. The
module protects parent terms if any child, grandchild, or deeper descendant
terms are referenced.


## FAQ

**Q: Does this module work with custom entity types?**

**A:** Yes! The module dynamically discovers taxonomy reference fields for any
entity type. You can add checkboxes for additional entity types by modifying
the vocabulary form alter hook.

**Q: What happens if I have a complex term hierarchy?**

**A:** The module recursively checks all descendant terms and protects parent
terms if any descendant is referenced. It includes infinite loop prevention
for circular references.

**Q: Can I configure this per content type?**

**A:** Currently, configuration is per-vocabulary and per-entity-type. If
protection is enabled for nodes, it checks ALL node bundles. Future versions
may add per-bundle granularity.

**Q: Does this affect performance?**

**A:** The module limits queries to 5 items per term and only runs checks when:
- Viewing a term edit form
- Attempting to delete a term
- Viewing term listing pages

For large sites, consider caching strategies if performance is a concern.

**Q: How do I add support for other entity types?**

**A:** Edit `term_delete_protection.module` and add a checkbox in the
`hook_form_taxonomy_vocabulary_form_alter()` function following the pattern
for nodes, commerce_product, or paragraph. The service layer will
automatically handle the entity type if it has taxonomy reference fields.


## Maintainers

Current maintainers:
- [Michalakis Nikitas] - [](https://www.drupal.org/u/nikitas)

This project has been sponsored by:
- https://pixelthis.gr
