<?php

namespace Drupal\tester\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;

/**
 * The TesterPlugin attribute.
 *
 * TesterPlugin classes define lists of URLs that are generated by their
 * related modules.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class TesterPlugin extends Plugin {

  /**
   * Constructs a TesterPlugin attribute.
   *
   * @param string $id
   *   A unique identifier for the tester plugin.
   * @param class-string|null $deriver
   *   (optional) The deriver class.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?string $deriver = NULL,
  ) {}

}
