<?php

declare(strict_types=1);

namespace Drupal\Tests\tester\Unit\Plugin\Tester;

use Drupal\tester\Plugin\Tester\SystemTester;
use Drupal\Tests\UnitTestCase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Tests the SystemTester plugin.
 *
 * @group tester
 * @coversDefaultClass \Drupal\tester\Plugin\Tester\SystemTester
 */
class SystemTesterTest extends UnitTestCase {

  /**
   * The system tester plugin.
   *
   * @var \Drupal\tester\Plugin\Tester\SystemTester
   */
  protected $systemTester;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $configuration = [];
    $plugin_id = 'system';
    $plugin_definition = [];

    $this->systemTester = new SystemTester(
      $configuration,
      $plugin_id,
      $plugin_definition
    );
  }

  /**
   * Tests the create method.
   *
   * @covers ::create
   */
  public function testCreate(): void {
    $container = $this->createMock(ContainerInterface::class);

    $instance = SystemTester::create(
      $container,
      [],
      'system',
      []
    );

    $this->assertInstanceOf(SystemTester::class, $instance);
  }

  /**
   * Tests urls method with no limit.
   *
   * @covers ::urls
   */
  public function testUrlsWithNoLimit(): void {
    $options = ['limit' => 0];

    $urls = $this->systemTester->urls($options);

    $expected = [
      '',
      '/',
      '/system/401',
      '/system/403',
      '/admin',
      '/system/404',
      '/foo-bar-baz',
    ];

    $this->assertEquals($expected, $urls);
  }

  /**
   * Tests urls method with limit.
   *
   * @covers ::urls
   */
  public function testUrlsWithLimit(): void {
    $options = ['limit' => 2];

    $urls = $this->systemTester->urls($options);

    // Should be limited to 2 URLs.
    $expected = [
      '',
      '/',
    ];

    $this->assertEquals($expected, $urls);
  }

  /**
   * Tests dependencies method.
   *
   * @covers ::dependencies
   */
  public function testDependencies(): void {
    $dependencies = $this->systemTester->dependencies();

    $expected = [
      'modules' => ['system'],
    ];

    $this->assertEquals($expected, $dependencies);
  }

}
