<?php

declare(strict_types=1);

namespace Drupal\Tests\tester\Unit;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\tester\TesterPluginManager;
use Drupal\Tests\UnitTestCase;

/**
 * Tests the TesterPluginManager.
 *
 * @group tester
 * @coversDefaultClass \Drupal\tester\TesterPluginManager
 */
class TesterPluginManagerTest extends UnitTestCase {

  /**
   * The tester plugin manager.
   *
   * @var \Drupal\tester\TesterPluginManager
   */
  protected $pluginManager;

  /**
   * Mock module handler.
   *
   * @var \Drupal\Core\Extension\ModuleHandlerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $moduleHandler;

  /**
   * Mock cache backend.
   *
   * @var \Drupal\Core\Cache\CacheBackendInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $cacheBackend;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->moduleHandler = $this->createMock(ModuleHandlerInterface::class);
    $this->cacheBackend = $this->createMock(CacheBackendInterface::class);

    $namespaces = new \ArrayObject([
      'Drupal\tester' => $this->root . '/modules/contrib/tester/src',
    ]);

    $this->pluginManager = new TesterPluginManager(
      $namespaces,
      $this->cacheBackend,
      $this->moduleHandler
    );
  }

  /**
   * Tests that the plugin manager is instantiated correctly.
   *
   * @covers ::__construct
   */
  public function testConstruct(): void {
    $this->assertInstanceOf(TesterPluginManager::class, $this->pluginManager);
  }

  /**
   * Tests getting plugin definitions.
   *
   * @covers ::getDefinitions
   */
  public function testGetDefinitions(): void {
    // Mock some plugin definitions.
    $definitions = [
      'node' => [
        'id' => 'node',
        'class' => 'Drupal\tester\Plugin\Tester\NodeTester',
        'provider' => 'tester',
      ],
      'user' => [
        'id' => 'user',
        'class' => 'Drupal\tester\Plugin\Tester\UserTester',
        'provider' => 'tester',
      ],
    ];

    // We can't easily mock the discovery process, so we'll test that the
    // method exists.
    $this->assertTrue(method_exists($this->pluginManager, 'getDefinitions'));
  }

  /**
   * Tests creating plugin instances.
   *
   * @covers ::createInstance
   */
  public function testCreateInstance(): void {
    // Test that the method exists - we can't easily test full functionality
    // in unit tests.
    $this->assertTrue(method_exists($this->pluginManager, 'createInstance'));
  }

}
