<?php

namespace Drupal\tester\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;

/**
 * Defines an interface for Tester plugins.
 *
 * Tester plugins provide URLs for crawling and testing different parts of a
 * Drupal site to identify PHP compatibility issues.
 */
interface TesterPluginInterface extends PluginInspectionInterface, ContainerFactoryPluginInterface {

  /**
   * Returns an array of URLs for testing.
   *
   * @param array $options
   *   The options passed to the command.
   *
   * @return array
   *   The URL path, with a leading slash (e.g. /node/3).
   */
  public function urls(array $options);

  /**
   * Returns an array of dependencies.
   *
   * This is a nested array, where the top-level is the dependency type
   * (e.g. "module" or "theme"). Each type can then declare an array of
   * dependencies. Normally, we expect `modules`.
   *
   * @return array
   *   An array of dependency requirements, keyed by dependency type.
   */
  public function dependencies();

}
