/**
 * @file
 * JavaScript for iterating special charts generated by Tether Stats Charts.
 */

(function ($, Drupal, drupalSettings) {

  "use strict";

  /**
   * Constructor for the tetherStatsChartHandler object.
   *
   * Provides API specific methods for Google Charts.
   *
   * @param chart
   *   DOM object for the chart.
   */
  Drupal.tetherStatsChartHandler = function (chart) {

    var chartId = chart.attr('id');

    this.chart = chart;
    this.settings = drupalSettings.tetherStatsGoogleChart[chartId];
    this.wrap = this.settings.googleChartWrapper;
  };

  /**
   * Update a Google chart with new data.
   */
  Drupal.tetherStatsChartHandler.prototype.updateChart = function(data) {

    var oldTable = this.wrap.getDataTable();
    var newTable = google.visualization.arrayToDataTable(data, true);

    // The JSON passed to the callback only contains data, so when building a new
    // data table, the column labels are set here.
    for (var i = 0; i < oldTable.getNumberOfColumns(); i++) {

      newTable.setColumnLabel(i, oldTable.getColumnLabel(i));
    }

    this.wrap.setDataTable(newTable);
    this.wrap.draw(this.chart[0]);
  };

  /**
   * Callback for initializing and drawing all charts.
   */
  Drupal.tetherStatsDrawAllCharts = function() {

    var settings;
    var chartType;

    for (var key in drupalSettings.tetherStatsGoogleChart) {

      settings = drupalSettings.tetherStatsGoogleChart[key];

      switch (settings.type) {

        case 'tether_stats-chart-combo':

          chartType = 'ComboChart';
          break;

        case 'tether_stats-chart-pie':

          chartType = 'PieChart';
          break;

      }

      if (typeof chartType === 'undefined') {
        return;
      }

      settings.googleChartWrapper = new google.visualization.ChartWrapper({
        "chartType": chartType,
        "dataTable": settings.data,
        "options": settings.options,
        "containerId": key,
      });

      settings.googleChartWrapper.draw();
    }
  };

  // Load the corechart package.
  google.load('visualization', '1', {packages: ['corechart']});

  // Set the onLoadCallback for Google.
  google.setOnLoadCallback(Drupal.tetherStatsDrawAllCharts);

})(jQuery, Drupal, drupalSettings);
