/**
 * @file
 * JavaScript for iterating special charts generated by Tether Stats Charts.
 */

(function ($, Drupal) {

  "use strict";

  Drupal.behaviors.tetherStatsCharts = {

    attach : function (context, settings) {

      tetherStatsChartsPrepareIterator();
    }
  };

  /**
   * Called on page load to prepare the charts for iteration.
   */
  function tetherStatsChartsPrepareIterator() {

    $('.tether_stats-chart-iterator').once('tether_stats-prepared').each(function () {

      var iterator = $(this);

      var previous = iterator.children('a.tether_stats-previous');
      var next = iterator.children('a.tether_stats-next');

      previous.click(tetherStatsChartsOnIterate);
      next.click(tetherStatsChartsOnIterate);
    });
  }

  /**
   * Handler for an iteration next or previous link.
   *
   * Iterates a chart forward or backwards depending on the
   * link that was clicked.
   */
  function tetherStatsChartsOnIterate(e) {

    var control = $(this);
    var iterator = control.parent();
    var chart = iterator.prev('.tether_stats-chart');
    var chart_id = chart.attr('id');
    var data_url;

    e.preventDefault();

    if (!control.hasClass('tether_stats-disabled') && !iterator.hasClass('tether_stats-iterating')) {

      iterator.addClass('tether_stats-iterating');

      data_url = '/tether-stats/chart-data';

      $.getJSON(
          data_url,
          {
		    "chart_id" : chart_id,
            "start" : iterator.attr('data-start'),
            "direction" : control.hasClass('tether_stats-next') ? 'next' : 'prev'
          },
          function (json) {tetherStatsChartsIterateChartCallback(json, chart_id);}
        );
    }
  }

  /**
   * Updates a chart with new data after an iteration call.
   *
   * Called after new chart data is retrieved for iteration. Updates the chart
   * and disables the next or previous buttons if a maximum or minimum
   * threshold has been reached.
   */
  function tetherStatsChartsIterateChartCallback(json, chart_id) {

    var chart = $('#' + chart_id);
    var iterator = chart.next('.tether_stats-chart-iterator');
    var chartHandler;
  
    // tetherStatsChartHandler is required for handling API specific updates.
    if (typeof Drupal.tetherStatsChartHandler === 'undefined') {
      return;
    }
	
	chartHandler = new Drupal.tetherStatsChartHandler(chart);

    if (json.status) {

      chartHandler.updateChart(json.data);

      // Update the period start pointer.
      iterator.attr('data-start', json.start);

      if (json.next) {
        iterator.find('a.tether_stats-next').removeClass('tether_stats-disabled');
      } else {
        iterator.find('a.tether_stats-next').addClass('tether_stats-disabled');
      }

      if (json.previous) {
        iterator.find('a.tether_stats-previous').removeClass('tether_stats-disabled');
      } else {
        iterator.find('a.tether_stats-previous').addClass('tether_stats-disabled');
      }
      iterator.removeClass('tether_stats-iterating');
    }
  }

})(jQuery, Drupal);
