<?php

namespace Drupal\tether_stats\Annotation;

use Drupal\Component\Annotation\Plugin;
use Drupal\Core\Annotation\Translation;

/**
 * Defines a chart renderer annotation object.
 *
 * Plugin Namespace: Plugin\tether_stats\Chart.
 *
 * @Annotation
 *
 * @see \Drupal\tether_stats\TetherStatsChartRendererPluginManager
 * @see \Drupal\tether_stats\TetherStatsChartRendererInterface
 * @see plugin_api
 */
class TetherStatsChartRenderer extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public string $id;

  /**
   * The human-readable name of the chart renderer tool.
   *
   * @var \Drupal\Core\Annotation\Translation
   */
  public Translation $label;

}
