<?php

namespace Drupal\tether_stats\Form;

use Drupal\Core\Entity\EntityConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Form to delete a derivative.
 */
class TetherStatsDerivativeDisableForm extends EntityConfirmFormBase {



  /**
   * {@inheritdoc}
   */
  public function getQuestion(): string {
    return $this->t('Are you sure you want to disable this derivative?');
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription(): string {
    return $this->t('Disabling this derivative will cause any identity sets referencing it to be ignored for stat collection.');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl(): Url {

    return new Url('entity.tether_stats_derivative.collection');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {

    /** @var \Drupal\tether_stats\TetherStatsDerivativeInterface $derivative */
    $derivative = $this->entity;

    $derivative->set('status', FALSE);
    $derivative->save();

    $this->messenger()->addMessage($this->t('The derivative %derivative has been disabled. Future identity sets referencing this derviative will not be tracked.',
      ['%derivative' => $this->entity->id()]));

    $form_state->setRedirect('entity.tether_stats_derivative.collection');
  }

}
