<?php

namespace Drupal\tether_stats\Form;

use Drupal\Core\Entity\EntityConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;

/**
 * Form to delete a derivative.
 */
class TetherStatsDerivativeEnableForm extends EntityConfirmFormBase {

  /**
   * {@inheritdoc}
   */
  public function getQuestion(): string {
    return $this->t('Are you sure you want to enable this derivative?');
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription(): string {
    return $this->t('Enabling this derivative will activate stat collection for any valid identity sets referencing it.');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl(): Url {

    return new Url('entity.tether_stats_derivative.collection');
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {

    /** @var \Drupal\tether_stats\TetherStatsDerivativeInterface $derivative */
    $derivative = $this->entity;

    $derivative->set('status', TRUE);
    $derivative->save();

    $this->messenger()->addMessage($this->t('The derivative %derivative has been enabled. You may now use this derivative to define additional tracking elements.',
      ['%derivative' => $this->entity->id()]));

    $form_state->setRedirect('entity.tether_stats_derivative.collection');
  }

}
