<?php

namespace Drupal\tether_stats;

use Drupal\tether_stats\Chart\TetherStatsChart;

/**
 * Interface for rendering charts.
 *
 * Classes which implement this interface will build a render array for a chart
 * object derived from TetherStatsChart for whatever charting system is in use.
 */
interface TetherStatsChartRendererInterface {

  /**
   * Builds a TetherStatsChart render array.
   *
   * Constructs the render array to display the chart using the the appropriate
   * chart provider.
   *
   * @param \Drupal\tether_stats\Chart\TetherStatsChart $chart
   *   The chart object to render.
   * @param array $options
   *   An array of options to send to the chart renderer.
   * @param bool $iterate
   *   If set to TRUE, iterator controls will be appended to the chart.
   *
   * @return array
   *   The renderable build array for the chart.
   */
  public function buildChart(TetherStatsChart $chart, array $options = [], bool $iterate = FALSE): array;

  /**
   * Gets the data table to send to the chart API.
   *
   * Used for converting the raw data table generated by the chart class into
   * a data table suitable to send to the handling chart API.
   *
   * @param \Drupal\tether_stats\Chart\TetherStatsChart $chart
   *   The chart object.
   *
   * @return array
   *   The data table.
   */
  public function getDataTable(TetherStatsChart $chart): array;

}
