<?php

namespace Drupal\tether_stats;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Component\Utility\Html;

/**
 * Defines a class to build a listing of derivative entities.
 *
 * @see \Drupal\tether_stats\Entity\TetherStatsDerivative
 */
class TetherStatsDerivativeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {

    $header['name'] = $this->t('Derivative name');
    $header['derivative_entity_type'] = $this->t('Entity Type Constraint');
    $header['derivative_bundle'] = $this->t('Bundle Constraint');
    $header['usage'] = $this->t('Elements Created');
    $header['description'] = $this->t('Description');
    $header['status'] = $this->t('Status');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {

    /** @var \Drupal\tether_stats\TetherStatsDerivativeInterface $derivative */
    $derivative = $entity;

    $row['name'] = $derivative->id();
    $row['derivative_entity_type'] = $derivative->getDerivativeEntityType();
    $row['derivative_bundle'] = $derivative->getDerivativeBundle();
    $row['usage'] = $derivative->getUsageCount();
    $row['description'] = Html::escape($derivative->getDescription());
    $row['status'] = $derivative->status() ? 'Enabled' : 'Disabled';
    return $row + parent::buildRow($derivative);
  }

}
