<?php

/**
 * @file
 * Hooks provided by the Tether Stats module.
 */

use Drupal\tether_stats\TetherStatsElementInterface;

/**
 * Populate the data column when tracking an activity.
 *
 * This hook allows data to be add to the custom "data" field on the
 * tether_stats_activity_log table. The data will be serialized and added to
 * the "data" column for the activity being tracked.
 *
 * @param \Drupal\tether_stats\TetherStatsElementInterface $element
 *   The stats element associated with the activity.
 * @param array $params
 *   The query string parameters passed on to the track controller.
 *
 * @return array
 *   The array of data to be serialized and added to the activity log.
 */
function hook_tether_stats_track_custom_data(TetherStatsElementInterface $element, array $params): array {

  return [
    'country' => 'Canada',
    'province' => 'British Columbia',
    'data' => $params['data'],
  ];
}
