<?php

/**
 * @file
 * Provide views data for tether_stats module.
 */

/**
 * Implements hook_views_data().
 */
function tether_stats_views_data(): array {

  $data = [];

  $data['tether_stats_element'] = [];
  $data['tether_stats_element']['table'] = [
    'group' => t('Tether Stats'),
    'provider' => 'tether_stats',
    'base' => [
      'field' => 'elid',
      'title' => t('Stats Elements'),
      'help' => t('The tether_stats_element table which contains base elements for statistics tracking.'),
    ],
  ];

  $data['tether_stats_element']['elid'] = [
    'title' => t('Element Id'),
    'help' => t('The primary key of the stats element table.'),
    'field' => [
      'id' => 'numeric',
    ],
  ];

  $data['tether_stats_element']['name'] = [
    'title' => t('Element Name'),
    'help' => t('The unique string identifier for custom elements that are not associated with an entity.'),
    'field' => [
      'id' => 'standard',
    ],
  ];

  $data['tether_stats_element']['entity_id'] = [
    'title' => t('Entity Id'),
    'help' => t('The entity id for the entity associated with this element.'),
    'field' => [
      'id' => 'standard',
    ],
  ];

  $data['tether_stats_element']['entity_type'] = [
    'title' => t('Entity Type'),
    'help' => t('The entity type of the entity associated with this element.'),
    'field' => [
      'id' => 'standard',
    ],
  ];

  $data['tether_stats_element']['url'] = [
    'title' => t('URL'),
    'help' => t('The The url if this element can refer to a page.'),
    'field' => [
      'id' => 'standard',
    ],
  ];

  $data['tether_stats_element']['query'] = [
    'title' => t('Query'),
    'help' => t('The query string of the url. Only used if query strings are allowed to spawn new page elements.'),
    'field' => [
      'id' => 'standard',
    ],
  ];

  $data['tether_stats_element']['derivative'] = [
    'title' => t('Derivative Id'),
    'help' => t('If this element is a derivative, then this is the string id of the derivative. This is NULL for base elements.'),
    'field' => [
      'id' => 'standard',
    ],
  ];

  $data['tether_stats_element']['count'] = [
    'title' => t('Total Event Count'),
    'help' => t('The total number of times a hit or click event has occurred for this element.'),
    'field' => [
      'id' => 'numeric',
    ],
  ];

  $data['tether_stats_element']['created'] = [
    'title' => t('Created'),
    'help' => t('The time when the element was first created.'),
    'field' => [
      'id' => 'date',
    ],
  ];

  $data['tether_stats_element']['changed'] = [
    'title' => t('Changed'),
    'help' => t('The time when the element was last updated.'),
    'field' => [
      'id' => 'date',
    ],
  ];

  $data['tether_stats_element']['last_activity'] = [
    'title' => t('Last Activity'),
    'help' => t('The time of the last activity on this element.'),
    'field' => [
      'id' => 'date',
    ],
  ];

  $data['tether_stats_activity_log'] = [];
  $data['tether_stats_activity_log']['table'] = [
    'group' => t('Tether Stats'),
    'provider' => 'tether_stats',
    'base' => [
      'field' => 'alid',
      'title' => t('Stats Activities'),
      'help' => t('The tether_stats_activity_log table which records stats-related events.'),
    ],
  ];

  $data['tether_stats_activity_log']['alid'] = [
    'title' => t('Activity Id'),
    'help' => t('The primary key of the table or the activity log id.'),
    'field' => [
      'id' => 'numeric',
    ],
  ];

  $data['tether_stats_activity_log']['elid'] = [
    'title' => t('Element Id'),
    'help' => t('The element on which this event has occurred.'),
    'relationship' => [
      'base' => 'tether_stats_element',
      'base field' => 'elid',
      'id' => 'standard',
      'label' => t('Activity Element'),
    ],
    'field' => [
      'id' => 'numeric',
    ],
  ];

  $data['tether_stats_activity_log']['type'] = [
    'title' => t('Type'),
    'help' => t("The type of event which has occurred such as a 'hit' or a 'click'."),
    'field' => [
      'id' => 'standard',
    ],
  ];

  $data['tether_stats_activity_log']['uid'] = [
    'title' => t('Uid'),
    'help' => t('The user which triggered the event if the user was not anonymous.'),
    'relationship' => [
      'base' => 'users_field_data',
      'base field' => 'uid',
      'id' => 'standard',
      'label' => t('User'),
    ],
    'field' => [
      'id' => 'standard',
    ],
  ];

  $data['tether_stats_activity_log']['referrer'] = [
    'title' => t('Referrer'),
    'help' => t("The url of the page which referred this event. Useful for page hits to determine where a user originated from. This value comes from the javascript document.referrer property and may not always be available."),
    'field' => [
      'id' => 'standard',
    ],
  ];

  $data['tether_stats_activity_log']['ip_address'] = [
    'title' => t('Referrer'),
    'help' => t("The ip address of the user that triggered the event."),
    'field' => [
      'id' => 'standard',
    ],
  ];

  $data['tether_stats_activity_log']['browser'] = [
    'title' => t('Browser'),
    'help' => t("The browser string of the user that triggered the event."),
    'field' => [
      'id' => 'standard',
    ],
  ];

  $data['tether_stats_activity_log']['created'] = [
    'title' => t('Created'),
    'help' => t("The time when the event occurred."),
    'field' => [
      'id' => 'date',
    ],
  ];

  $data['tether_stats_impression_log'] = [];
  $data['tether_stats_impression_log']['table'] = [
    'group' => t('Tether Stats'),
    'provider' => 'tether_stats',
  ];

  $data['tether_stats_impression_log']['alid'] = [
    'title' => t('Activity Id'),
    'help' => t('The event activity on which this impression occurred.'),
    'relationship' => [
      'base' => 'tether_stats_activity_log',
      'base field' => 'alid',
      'id' => 'standard',
      'label' => t('Impression Activity'),
    ],
    'field' => [
      'id' => 'numeric',
    ],
  ];

  $data['tether_stats_impression_log']['elid'] = [
    'title' => t('Element Id'),
    'help' => t('The impressed element.'),
    'relationship' => [
      'base' => 'tether_stats_element',
      'base field' => 'elid',
      'id' => 'standard',
      'label' => t('Impressed Element'),
    ],
    'field' => [
      'id' => 'numeric',
    ],
  ];

  return $data;
}

/**
 * Implements hook_views_data_alter().
 */
function tether_stats_views_data_alter(array &$data): void {

  foreach (\Drupal::entityTypeManager()->getDefinitions() as $entity_type_id => $entity_type) {
    $base_table = $entity_type->getDataTable() ?: $entity_type->getBaseTable();
    $args = ['@entity_type' => $entity_type_id];

    $alias = 'tether_stats_element' . '_' . $base_table;
    $extra = "{$alias}.entity_type = '{$entity_type->id()}' AND {$alias}.name IS NULL AND {$alias}.derivative IS NULL";

    $data[$base_table]['tether_stats_elid'] = [
      'title' => t('The stats element of the @entity_type.', $args),
      'help' => t('Relate all @entity_type entities to matching stats elements.', $args),
      'relationship' => [
        'group' => t('Tether Stats'),
        'label' => t('Stats Elements'),
        'base' => 'tether_stats_element',
        'base field' => 'entity_id',
        'field' => $entity_type->getKey('id'),
        'id' => 'standard',
        'extra' => $extra,
      ],
    ];
  }

}
