<?php

namespace Drupal\Tests\text_summary_formater\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Test the behavior of the formatter.
 */
class TextSummaryFormatterTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'node',
    'text',
    'field',
    'user',
    'text_summary_formatter',
  ];

  /**
   * Test behavior of the formatter.
   */
  public function testFormatter(): void {
    $this->drupalCreateContentType(['type' => 'page', 'name' => 'Page']);

    // Format body field using text_summary_formatter for the default display.
    $display = \Drupal::entityTypeManager()
      ->getStorage('entity_view_display')
      ->load('node.page.default');
    $display->setComponent('body', [
      'type' => 'text_summary_formatter',
    ])->save();

    // Create a node with both body and summary. The formatter should only
    // display the summary.
    $node = $this->createNode([
      'type' => 'page',
      'body' => [
        'value' => 'This is the full body text.',
        'summary' => 'This is the summary text.',
        'format' => 'plain_text',
      ],
    ]);

    $this->drupalGet($node->toUrl());
    $session = $this->assertSession();

    // Assert that the summary is visible.
    $session->pageTextContains('This is the summary text.');

    // Assert that the body text is not visible.
    $session->responseNotContains('This is the full body text.');

    // Create another node without a summary. The formatter should not render
    // anything as the summary is empty.
    $node2 = $this->createNode([
      'type' => 'page',
      'body' => [
        'value' => 'This is the full body text without a summary.',
        'format' => 'plain_text',
      ],
    ]);

    $this->drupalGet($node2->toUrl());

    // Assert that the body text is not visible.
    $session->responseNotContains('This is the full body text without a summary.');
  }

}
