# Text Link

A Drupal module that provides a configurable field formatter to create links from text field values with customizable base URLs.

## Description

The Text Link module allows you to convert any text field into clickable links by combining the field values with a configurable base URL. This is particularly useful for creating links to external profiles, search results, or any URL pattern that incorporates user-provided text.

## Features

- **Configurable Base URL**: Set any base URL that will be combined with field values
- **Flexible Link Text**: Use placeholders to customize how links are displayed
- **Auto-sanitization**: Automatically clean field values for URL usage
- **Multiple Separator Options**: Choose how spaces are handled in URLs (hyphens, underscores, dots, or removal)
- **Target Window Control**: Option to open links in new windows
- **Multiple Field Type Support**: Works with string, text, and long text fields

## Installation

1. Download and extract the module to your `modules/contrib/` directory
2. Enable the module via the admin interface or using Drush:
   ```bash
   drush en textlink
   ```

## Usage

1. Navigate to the "Manage display" settings for any content type
2. Find a text field you want to format as links
3. Change the formatter to "Configurable URL Link"
4. Click the settings gear icon to configure:
   - **Base URL**: The URL prefix (e.g., `https://example.com/user/`)
   - **Link text**: How the link appears (use `@value` for original text, `@sanitized` for cleaned text)
   - **Auto-sanitize**: Whether to clean field values for URL usage
   - **Separator**: How to handle spaces when sanitizing
   - **Open in new window**: Whether links open in new tabs

## Configuration Examples

### LinkedIn Profile Links

- Base URL: `https://www.linkedin.com/in/`
- Link text: `View @value on LinkedIn`
- Auto-sanitize: Enabled
- Separator: Hyphen (-)

### Search Engine Links

- Base URL: `https://www.google.com/search?q=`
- Link text: `Search for "@value"`
- Auto-sanitize: Enabled

### Custom Page Links

- Base URL: `https://mysite.com/page/`
- Link text: `@value`
- Auto-sanitize: Disabled (if URLs are pre-formatted)

## Placeholders

- `@value`: The original field value
- `@sanitized`: The sanitized field value (useful when auto-sanitize is enabled)

## Auto-Sanitization

When enabled, auto-sanitization:

- Converts text to lowercase
- Replaces multiple spaces with single spaces
- Replaces spaces with chosen separator
- Removes special characters except alphanumeric, dots, hyphens, and underscores
- Trims separators from beginning and end

Example: "John Doe Profile" becomes "john-doe-profile"

## Requirements

- Drupal 10.0 or higher
- PHP 8.1 or higher

## Supported Field Types

- String (short)
- Text (formatted)

## Maintainers

- Makbul Khan - makbul.khan8@gmail.com
