## INTRODUCTION

Texts is a module, that allows to manage and translate strings / texts using a key-based approach.
If you work in a decoupled environment, this module allows you to manage your frontend translations within Drupal with ease.
The module offers an improved UI to manage translations in the Drupal backend.

It supports pluralization (singular / plural) and placeholders, like the normal t() function.

The module comes with optional GraphQL support to fetch the translations in a decoupled environment.

https://www.drupal.org/project/texts

## API
You can use the function `getTexts()`: (similar to `t()`)
### Example:
```
getTexts(
  'login.button', // The translation key
  ['@name => 'Luke Skywalker'], // (optional) placeholders
  ['default_translation' => 'Login Button @name', 'context' => 'default'] // (optional) options
)
```
This will create a translation based on the key `login.button` if it does not exist and return its translation.

You can use the function `getTextsPlural()`: (similar to `formatPlural()`)
### Example:
```
getTextsPlural(
   1, // count
  'login.button', // The translation key
  '1 year @name', // singular
  '@count years @name', // plural
  ['@name => 'Luke Skywalker'], // (optional) placeholders 
  ['default_translation' => 'Login Button @name', 'context' => 'default'] // (optional) options
)
```
This will create pluralized texts.

## Twig support
You can use the following Twig filters:
* `|getTexts(key)`
* `|getTextsPlural(key)`

## REQUIREMENTS
* locale module
* content_translation module.

## INSTALLATION

* Standard installation with no dependencies.
  See http://drupal.org/node/70151 for further information.


## RELATED MODULES

No directly comparable modules exist in Drupal 8.

* Locale module of drupal core provides the t() function and string based translations based on an English base string.

## CONFIGURATION

* You can configure the module under /admin/config/regional/texts
* It is possible to hide unwanted language in the overview.


## MAINTAINERS

Current maintainers:

* ayalon - https://www.drupal.org/u/ayalon

If you want to help or be involved, please contact me.

If you find any issues, please create an issue after checking that the issue
is not a duplicate of an existing issue.
