<?php

namespace Drupal\texts;

use Drupal\Core\Entity\ContentEntityTypeInterface;
use Drupal\Core\Entity\Sql\SqlContentEntityStorageSchema;
use Drupal\Core\Field\FieldStorageDefinitionInterface;

/**
 * Defines a schema handler that supports defining base field indexes.
 */
class TextsContentEntityStorageSchema extends SqlContentEntityStorageSchema {

  /**
   * {@inheritdoc}
   */
  protected function getEntitySchema(ContentEntityTypeInterface $entity_type, $reset = FALSE) {
    $schema = parent::getEntitySchema($entity_type, $reset);

    // Add composite unique index on (key, context, langcode) to prevent duplicate
    // entities with the same key+context+langcode combination. This is the primary
    // defense against race conditions during concurrent entity creation.
    // Note: The same key+context can exist for different languages (translations).
    if (isset($schema['texts_field_data'])) {
      $schema['texts_field_data']['unique keys']['texts__key_context_langcode'] = [
        'key',
        'context',
        'langcode',
      ];
    }

    return $schema;
  }

  /**
   * {@inheritdoc}
   */
  protected function getSharedTableFieldSchema(FieldStorageDefinitionInterface $storage_definition, $table_name, array $column_mapping) {
    $schema = parent::getSharedTableFieldSchema($storage_definition, $table_name, $column_mapping);

    $entity_type = $this->entityTypeManager->getDefinition($storage_definition->getTargetEntityTypeId());
    $field_indexes = $entity_type->get('field_indexes');
    foreach ($field_indexes as $field_name) {
      if ($field_name == $storage_definition->getName()) {
        $this->addSharedTableFieldIndex($storage_definition, $schema);
      }
    }

    return $schema;
  }

}
