<?php

namespace Drupal\texts;

interface TextsStorageInterface {

  /**
   * Load a text by key.
   *
   * @param string $key
   *   The translation key.
   * @param string $context
   *   The translation context.
   *
   * @return \Drupal\texts\TextsInterface|null
   *   The translation entity or NULL if not found.
   */
  public function loadByKey(string $key, string $context = 'default'): TextsInterface|null;

}
