<?php
// phpcs:ignoreFile
// cSpell:disable
/**
 * @file
 * A database agnostic dump for testing purposes.
 */

use Drupal\Core\Database\Database;

$connection = Database::getConnection();
// Ensure any tables with a serial column with a value of 0 are created as
// expected.
if ($connection->databaseType() === 'mysql') {
  $sql_mode = $connection->query("SELECT @@sql_mode;")->fetchField();
  $connection->query("SET sql_mode = '$sql_mode,NO_AUTO_VALUE_ON_ZERO'");
}

// Provision user accounts.
$connection->delete('users')->execute();
$connection->insert('users')
  ->fields([
    'uid',
    'uuid',
    'langcode',
  ])
  ->values([
    'uid' => 0,
    'uuid' => '0189f0d8-e8b5-4198-a1dd-2f6504fef289',
    'langcode' => 'en',
  ])
  ->values([
    'uid' => 1,
    'uuid' => 'c6324d55-b280-4845-af40-1b3cf7de6676',
    'langcode' => 'en',
  ])
  ->values([
    'uid' => 2,
    'uuid' => '0defcbf7-7f58-4418-88bc-636b66dcf22d',
    'langcode' => 'en',
  ])
  ->values([
    'uid' => 3,
    'uuid' => 'a754881e-34a1-4174-a8c6-3b935cbee922',
    'langcode' => 'en',
  ])
  ->values([
    'uid' => 4,
    'uuid' => '529a3f82-c65f-402f-ab6f-b52a2ecf4001',
    'langcode' => 'en',
  ])
  ->values([
    'uid' => 5,
    'uuid' => 'bd6712ad-01e6-4c1b-ae07-2ca421854f62',
    'langcode' => 'en',
  ])
  ->values([
    'uid' => 6,
    'uuid' => '5ff29904-7198-4395-a2f0-e8869c829a0b',
    'langcode' => 'en',
  ])
  ->execute();

// Set TFA and dependencies as enabled.
$result = $connection->select('config', 'c')
  ->condition('c.name', 'core.extension', '=')
  ->fields('c', ['collection', 'name', 'data'])
  ->execute()
  ->fetchAssoc();

$data = unserialize($result['data']);
$data['module']['encrypt'] = 0;
$data['module']['encrypt_test'] = 0;
$data['module']['key'] = 0;
$data['module']['tfa'] = 0;
$result['data'] = serialize($data);

$connection->update('config')
  ->condition('name', 'core.extension', '=')
  ->fields($result)
  ->execute();

// Add config entries for TFA,encrypt,key.
$connection->insert('config')
  ->fields([
    'collection',
    'name',
    'data',
  ])
  ->values([
    'collection' => '',
    'name' => 'encrypt.profile.test_encryption_method',
    'data' => 'a:9:{s:4:"uuid";s:36:"14dc9629-f9f7-4032-92da-0043f872d42d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:34:"key.key.test_encryption_secret_key";}s:6:"module";a:1:{i:0;s:12:"encrypt_test";}}s:2:"id";s:22:"test_encryption_method";s:5:"label";s:22:"Test Encryption Method";s:17:"encryption_method";s:22:"test_encryption_method";s:31:"encryption_method_configuration";a:0:{}s:14:"encryption_key";s:26:"test_encryption_secret_key";}',
  ])
  ->values([
    'collection' => '',
    'name' => 'encrypt.settings',
    'data' => 'a:3:{s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"CMyccvAuba2yH-HYmcEL0pq1Seyxzq9VHhKbQKwAWY4";}s:20:"check_profile_status";b:1;s:24:"allow_deprecated_plugins";b:0;}',
  ])
  ->values([
    'collection' => '',
    'name' => 'key.key.test_encryption_secret_key',
    'data' => 'a:13:{s:4:"uuid";s:36:"8489888f-6880-42f2-abb6-2ef0860077de";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:2:"id";s:26:"test_encryption_secret_key";s:5:"label";s:26:"Test Encryption Secret Key";s:11:"description";s:0:"";s:8:"key_type";s:10:"encryption";s:17:"key_type_settings";a:1:{s:8:"key_size";i:128;}s:12:"key_provider";s:6:"config";s:21:"key_provider_settings";a:2:{s:9:"key_value";s:16:"mustbesixteenbit";s:14:"base64_encoded";b:0;}s:9:"key_input";s:10:"text_field";s:18:"key_input_settings";a:1:{s:14:"base64_encoded";b:0;}}',
  ])
  ->values([
    'collection' => '',
    'name' => 'tfa.settings',
    'data' => "a:18:{s:5:\"_core\";a:1:{s:19:\"default_config_hash\";s:43:\"sQBXB9av8w5pYBqIRFEkC-DhSW3HYKswHbJzqnWBKPo\";}s:8:\"langcode\";s:2:\"en\";s:7:\"enabled\";b:1;s:14:\"required_roles\";a:3:{s:13:\"authenticated\";s:1:\"0\";s:14:\"content_editor\";s:1:\"0\";s:13:\"administrator\";s:1:\"0\";}s:12:\"send_plugins\";a:0:{}s:13:\"login_plugins\";a:0:{}s:21:\"login_plugin_settings\";a:1:{s:19:\"tfa_trusted_browser\";a:3:{s:23:\"cookie_allow_subdomains\";b:1;s:17:\"cookie_expiration\";i:30;s:11:\"cookie_name\";s:19:\"tfa-trusted-browser\";}}s:26:\"allowed_validation_plugins\";a:2:{s:8:\"tfa_totp\";s:8:\"tfa_totp\";s:8:\"tfa_hotp\";s:8:\"tfa_hotp\";}s:25:\"default_validation_plugin\";s:8:\"tfa_totp\";s:26:\"validation_plugin_settings\";a:3:{s:8:\"tfa_totp\";a:4:{s:9:\"time_skew\";i:2;s:16:\"site_name_prefix\";i:1;s:11:\"name_prefix\";s:3:\"TFA\";s:6:\"issuer\";s:6:\"Drupal\";}s:8:\"tfa_hotp\";a:4:{s:14:\"counter_window\";i:10;s:16:\"site_name_prefix\";i:1;s:11:\"name_prefix\";s:3:\"TFA\";s:6:\"issuer\";s:6:\"Drupal\";}s:17:\"tfa_recovery_code\";a:1:{s:21:\"recovery_codes_amount\";i:10;}}s:15:\"validation_skip\";i:3;s:26:\"users_without_tfa_redirect\";b:0;s:10:\"encryption\";s:22:\"test_encryption_method\";s:18:\"tfa_flood_uid_only\";i:1;s:16:\"tfa_flood_window\";i:300;s:19:\"tfa_flood_threshold\";i:6;s:9:\"help_text\";s:36:\"Contact support to reset your access\";s:4:\"mail\";a:2:{s:25:\"tfa_enabled_configuration\";a:2:{s:7:\"subject\";s:58:\"Your [site:name] account now has two-factor authentication\";s:4:\"body\";s:347:\"[user:display-name],\r\n\r\nThanks for configuring two-factor authentication on your [site:name] account!\r\n\r\nThis additional level of security will help to ensure that only you are able to log in to your account.\r\n\r\nIf you ever lose the device you configured, you should act quickly to delete its association with this account.\r\n\r\n--\r\n[site:name] team\";}s:26:\"tfa_disabled_configuration\";a:2:{s:7:\"subject\";s:64:\"Your [site:name] account no longer has two-factor authentication\";s:4:\"body\";s:205:\"[user:display-name],\r\n\r\nTwo-factor authentication has been disabled on your [site:name] account.\r\n\r\nIf you did not take this action, please contact a site administrator immediately.\r\n\r\n--\r\n[site:name] team\";}}}",
  ])
  ->execute();

// Define existing schema versions.
$connection->insert('key_value')
  ->fields([
    'collection',
    'name',
    'value',
  ])
  ->values([
    'collection' => 'system.schema',
    'name' => 'encrypt',
    'value' => 'i:8003;',
  ])
  ->values([
    'collection' => 'system.schema',
    'name' => 'encrypt_test',
    'value' => 'i:8000;',
  ])
  ->values([
    'collection' => 'system.schema',
    'name' => 'key',
    'value' => 'i:8002;',
  ])
  ->execute();

// Install the encrypt/key entity types.
$connection->insert('key_value')
->fields([
  'collection',
  'name',
  'value',
])

->values([
  'collection' => 'entity.definitions.installed',
  'name' => 'encryption_profile.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:18:"encryption_profile";s:8:" * class";s:39:"Drupal\encrypt\Entity\EncryptionProfile";s:11:" * provider";s:7:"encrypt";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:4:"uuid";s:4:"uuid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:16:" * originalClass";s:39:"Drupal\encrypt\Entity\EncryptionProfile";s:11:" * handlers";a:4:{s:12:"list_builder";s:54:"Drupal\encrypt\Controller\EncryptionProfileListBuilder";s:4:"form";a:4:{s:3:"add";s:41:"Drupal\encrypt\Form\EncryptionProfileForm";s:4:"edit";s:41:"Drupal\encrypt\Form\EncryptionProfileForm";s:6:"delete";s:47:"Drupal\encrypt\Form\EncryptionProfileDeleteForm";s:4:"test";s:45:"Drupal\encrypt\Form\EncryptionProfileTestForm";}s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:18:"administer encrypt";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:5:{s:8:"add-form";s:44:"/admin/config/system/encryption/profiles/add";s:9:"edit-form";s:68:"/admin/config/system/encryption/profiles/manage/{encryption_profile}";s:11:"delete-form";s:75:"/admin/config/system/encryption/profiles/manage/{encryption_profile}/delete";s:9:"test-form";s:73:"/admin/config/system/encryption/profiles/manage/{encryption_profile}/test";s:10:"collection";s:40:"/admin/config/system/encryption/profiles";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:18:"Encryption Profile";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:30:"config:encryption_profile_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:0:{}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:7:"profile";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:17:"encryption_method";i:3;s:14:"encryption_key";i:4;s:31:"encryption_method_configuration";}s:21:" * mergedConfigExport";a:0:{}}',
])

->values([
  'collection' => 'entity.definitions.installed',
  'name' => 'key.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:3:"key";s:8:" * class";s:21:"Drupal\key\Entity\Key";s:11:" * provider";s:3:"key";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:21:"Drupal\key\Entity\Key";s:11:" * handlers";a:4:{s:12:"list_builder";s:36:"Drupal\key\Controller\KeyListBuilder";s:4:"form";a:3:{s:3:"add";s:26:"Drupal\key\Form\KeyAddForm";s:4:"edit";s:27:"Drupal\key\Form\KeyEditForm";s:6:"delete";s:29:"Drupal\key\Form\KeyDeleteForm";}s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:15:"administer keys";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:4:{s:8:"add-form";s:29:"/admin/config/system/keys/add";s:9:"edit-form";s:38:"/admin/config/system/keys/manage/{key}";s:11:"delete-form";s:45:"/admin/config/system/keys/manage/{key}/delete";s:10:"collection";s:25:"/admin/config/system/keys";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:3:"Key";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:15:"config:key_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:1:{s:6:"module";s:3:"key";}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:3:"key";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:9:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:8:"key_type";i:4;s:17:"key_type_settings";i:5;s:12:"key_provider";i:6;s:21:"key_provider_settings";i:7;s:9:"key_input";i:8;s:18:"key_input_settings";}s:21:" * mergedConfigExport";a:0:{}}',
])
->values([
  'collection' => 'entity.definitions.installed',
  'name' => 'key_config_override.entity_type',
  'value' => 'O:42:"Drupal\Core\Config\Entity\ConfigEntityType":44:{s:5:" * id";s:19:"key_config_override";s:8:" * class";s:35:"Drupal\key\Entity\KeyConfigOverride";s:11:" * provider";s:3:"key";s:15:" * static_cache";b:0;s:15:" * render_cache";b:1;s:19:" * persistent_cache";b:1;s:14:" * entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:16:" * originalClass";s:35:"Drupal\key\Entity\KeyConfigOverride";s:11:" * handlers";a:4:{s:12:"list_builder";s:50:"Drupal\key\Controller\KeyConfigOverrideListBuilder";s:4:"form";a:2:{s:3:"add";s:40:"Drupal\key\Form\KeyConfigOverrideAddForm";s:6:"delete";s:43:"Drupal\key\Form\KeyConfigOverrideDeleteForm";}s:6:"access";s:45:"Drupal\Core\Entity\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\Core\Config\Entity\ConfigEntityStorage";}s:19:" * admin_permission";s:38:"administer key configuration overrides";s:24:" * collection_permission";N;s:25:" * permission_granularity";s:11:"entity_type";s:8:" * links";a:3:{s:8:"add-form";s:57:"/admin/config/development/configuration/key-overrides/add";s:11:"delete-form";s:89:"/admin/config/development/configuration/key-overrides/manage/{key_config_override}/delete";s:10:"collection";s:53:"/admin/config/development/configuration/key-overrides";}s:21:" * bundle_entity_type";N;s:12:" * bundle_of";N;s:15:" * bundle_label";N;s:13:" * base_table";N;s:22:" * revision_data_table";N;s:17:" * revision_table";N;s:13:" * data_table";N;s:11:" * internal";b:0;s:15:" * translatable";b:0;s:19:" * show_revision_ui";b:0;s:8:" * label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:26:"Key Configuration Override";s:12:" * arguments";a:0:{}s:10:" * options";a:0:{}}s:19:" * label_collection";s:0:"";s:17:" * label_singular";s:0:"";s:15:" * label_plural";s:0:"";s:14:" * label_count";a:0:{}s:15:" * uri_callback";N;s:8:" * group";s:13:"configuration";s:14:" * group_label";O:48:"Drupal\Core\StringTranslation\TranslatableMarkup":3:{s:9:" * string";s:13:"Configuration";s:12:" * arguments";a:0:{}s:10:" * options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:" * field_ui_base_route";N;s:26:" * common_reference_target";b:0;s:22:" * list_cache_contexts";a:0:{}s:18:" * list_cache_tags";a:1:{i:0;s:31:"config:key_config_override_list";}s:14:" * constraints";a:0:{}s:13:" * additional";a:1:{s:6:"module";s:3:"key";}s:14:" * _serviceIds";a:0:{}s:18:" * _entityStorages";a:0:{}s:20:" * stringTranslation";N;s:16:" * config_prefix";s:15:"config_override";s:14:" * lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:" * config_export";a:7:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"config_type";i:3;s:13:"config_prefix";i:4;s:11:"config_name";i:5;s:11:"config_item";i:6;s:6:"key_id";}s:21:" * mergedConfigExport";a:0:{}}',
])
->execute();

// Reset the SQL mode.
if ($connection->databaseType() === 'mysql') {
  $connection->query("SET sql_mode = '$sql_mode'");
}
