<?php

namespace Drupal\tfa_email_support\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Config form for TFA Email templates.
 */
class EmailTemplateSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['tfa_email_support.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'tfa_email_support_email_template_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('tfa_email_support.settings');

    // OTP Email
    $form['otp'] = [
      '#type' => 'details',
      '#title' => $this->t('OTP Email'),
      '#open' => TRUE,
    ];
    $form['otp']['otp_subject'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Subject'),
      '#default_value' => $config->get('otp_subject'),
      '#description' => $this->t('Use placeholders such as @username, @site_name.'),
    ];
    $form['otp']['otp_body'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Body'),
      '#default_value' => $config->get('otp_body'),
      '#description' => $this->t('Available placeholders: @username, @otp, @expiry_minutes, @site_name, @support_email.'),
      '#rows' => 6,
    ];
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->configFactory->getEditable('tfa_email_support.settings')
      ->set('otp_subject', $form_state->getValue('otp_subject'))
      ->set('otp_body', $form_state->getValue('otp_body'))
      ->set('setup_subject', $form_state->getValue('setup_subject'))
      ->set('setup_body', $form_state->getValue('setup_body'))
      ->set('backup_codes_subject', $form_state->getValue('backup_codes_subject'))
      ->set('backup_codes_body', $form_state->getValue('backup_codes_body'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
