<?php

namespace Drupal\tfa_headless\EventSubscriber;

use Drupal\Component\Utility\Crypt;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpKernel\Event\ResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\Routing\RequestContext;

/**
 * The OauthReponseSubscriber class.
 */
class OauthResponseSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a new OauthResponseSubscriber object.
   */
  public function __construct(
    protected RequestContext $requestContext,
    protected Session $session,
  ) {}

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents() {
    return [
      KernelEvents::RESPONSE => ['onKernelResponse', -10],
    ];
  }

  /**
   * Alter info returned by the /oauth/token endpoint.
   *
   * @param \Symfony\Component\HttpKernel\Event\ResponseEvent $event
   *   The response event.
   */
  public function onKernelResponse(ResponseEvent $event) {
    $request = $event->getRequest();
    $path = $this->requestContext->getPathInfo();
    // Only override if session parameter is given.
    if (str_contains($path, '/oauth/token') && $request->request->get('session') == TRUE && $request->isMethod('POST')) {
      $response = $event->getResponse();
      $content = json_decode($response->getContent(), TRUE);

      if (json_last_error() === JSON_ERROR_NONE && is_array($content)) {
        $this->session->setId(Crypt::randomBytesBase64());
        if ($content['access_token']) {
          $this->session->set('access_token', json_encode($content));
          $content = ['session' => $this->session->getId()];
        }

        $response->setContent(json_encode($content));
        $response->headers->set('Content-Type', 'application/json');
      }
    }
  }

}
