# TFA Headless
Provides headless TFA support for Google Authenticator on top of the [TFA](https://www.drupal.org/project/tfa) module and augments OAuth token responses so decoupled clients can keep working with session-backed requests.

### REST resources
This module ships four REST resources that expose the full TOTP lifecycle:

- `/api/totp/generate` – generates a seed and provisioning URI for QR-code setup.
- `/api/totp/status` – returns whether TFA is enabled for the current user.
- `/api/totp/register` – stores the generated seed for the current user.
- `/api/totp/login` – validates a submitted TOTP code and records the successful attempt to prevent replay.

The endpoints can be enabled under `Configuration > Web services > REST`. Remember to assign the required permissions per resource to the intended roles.

### OAuth session bridge
`Drupal\tfa_headless\EventSubscriber\OauthResponseSubscriber` listens to every OAuth token response produced by `simple_oauth` (or subclasses of its controller) when the `session` request parameter is present. On successful token grants it:

- Generates or migrates a PHP session.
- Stores the entire OAuth payload (access token, refresh token, scopes, etc.) inside that session for later retrieval.
- Returns a minimal response of the form `{"session": "{session-id}"}` so JavaScript clients can persist a single opaque identifier instead of the raw access token.

This keeps the original OAuth error payload intact on failures and adds structured logging when responses are malformed or missing `access_token`.

### TFA helper service
`Drupal\tfa_headless\Service\TfaHeadlessService` offers reusable helpers for custom code:

- Encrypting and storing the TOTP seed and accepted codes.
- Validating codes with window skew handling and writing replay-prevention markers.
- Looking up users or access-token payloads based on the generated session identifier.

## Setup

```bash
composer require drupal/tfa_headless
drush en tfa_headless
```

### REST configuration
Enable the resources under `Configuration > Web services > REST` and assign the appropriate request format (usually JSON), authentication, and permissions.

### OAuth usage
To make use of the session bridge, include `session=1` (or any truthy value) in the body of POST requests to your OAuth token endpoint. Successful responses will return a session identifier that you can present on subsequent requests via the `Cookie` header (`SESS...={session-id}`) or whichever transport your client prefers.

## Additional Requirements
- Depends on the [TFA](https://www.drupal.org/project/tfa) module.
- Uses Drupal core REST module to expose the endpoints.
- [REST UI](https://www.drupal.org/project/restui) is recommended for managing resource configuration visually.
- Simple OAuth (or any controller extending its token endpoint) is required for the OAuth response subscriber to activate.

## Notes
- Logging is performed through the `tfa_headless` channel; check the Drupal log for diagnostics when responses fail validation.
- When integrating with a decoupled front-end, ensure HTTPS is used so session identifiers are transported securely.
