<?php

namespace Drupal\theme_breakpoints_js\Hook;

use Drupal\Component\Serialization\Json;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\theme_breakpoints_js\ThemeBreakpointsJs;

/**
 * Hook implementations for Theme Breakpoints for Javascript.
 */
readonly class ThemeBreakpointsJsHooks {

  public function __construct(
    private ThemeBreakpointsJs $themeBreakpointsJs,
  ) {
  }

  /**
   * Implements hook_page_attachments().
   */
  #[Hook('page_attachments')]
  public function pageAttachments(array &$page): void {
    $breakpoints = [];
    /** @var \Drupal\theme_breakpoints_js\ThemeBreakpointsJs $theme_breakpoints_js */
    $theme_breakpoints = $this->themeBreakpointsJs->getBreakpointsForActiveTheme();

    foreach ($theme_breakpoints as $name => $definition) {
      $breakpoints[] = [
        'name' => $name,
        'mediaQuery' => $definition->getMediaQuery(),
        'multipliers' => $definition->getMultipliers(),
      ];
    }

    $page['#attached']['drupalSettings']['theme_breakpoints'] = Json::encode($breakpoints);
    $page['#attached']['library'][] = 'theme_breakpoints_js/breakpointsLoader';
  }

}
