/**
 * @file
 * Parse inline JSON and initialize the breakpointSettings global object.
 */

(function (drupalSettings, window) {
  /**
   * Variable generated by Breakpoint settings.
   *
   * @global
   *
   * @type {object}
   */
  window.themeBreakpoints = {};

  if (typeof drupalSettings.theme_breakpoints !== 'undefined') {
    window.themeBreakpoints = new (function () {
      this.Breakpoints = JSON.parse(drupalSettings.theme_breakpoints);
      this.currentBreakpoint = false;

      this.getCurrentBreakpoint = function () {
        return this.currentBreakpoint;
      };

      const triggerBreakpointChange = function () {
        // This is deprecated but needed for IE compatibility.
        const breakpointChangedEvent = document.createEvent('CustomEvent');
        breakpointChangedEvent.initCustomEvent(
          'themeBreakpoint:changed',
          true,
          true,
          this.currentBreakpoint,
        );
        window.dispatchEvent(breakpointChangedEvent);
      }.bind(this);

      this.breakpointChangeHandler = function () {
        const mqls = this.mediaQueryListeners;
        let breakpointCandidate = false;
        for (let i = 0; i < mqls.length; i++) {
          if (mqls[i].matches) {
            breakpointCandidate = this.Breakpoints[i];
          }
        }
        if (
          breakpointCandidate &&
          breakpointCandidate !== this.currentBreakpoint
        ) {
          this.currentBreakpoint = breakpointCandidate;
          triggerBreakpointChange();
        }
      }.bind(this);

      this.mediaQueryListeners = function () {
        const breakpoints = this.Breakpoints;
        if (!Array.isArray(breakpoints) || breakpoints.length === 0) {
          return [];
        }
        let currentBreakpoint = false;
        const mqls = [];
        for (let i = 0; i < breakpoints.length; i++) {
          if (breakpoints[i].mediaQuery === '') {
            breakpoints[i].mediaQuery = '(min-width: 0em)';
          }
          const mql = window.matchMedia(breakpoints[i].mediaQuery);
          mql.addListener(this.breakpointChangeHandler);
          mqls.push(mql);
          if (mql.matches) {
            currentBreakpoint = breakpoints[i];
          }
        }

        this.currentBreakpoint = currentBreakpoint;

        return mqls;
      }.call(this);
    })();
  }
})(drupalSettings, window);
