<?php

declare(strict_types=1);

namespace Drupal\Tests\theme_breakpoints_js\Kernel;

use Drupal\KernelTests\KernelTestBase;
use Drupal\theme_breakpoints_js\Hook\ThemeBreakpointsJsHooks;

/**
 * Tests the ThemeBreakpointsJsHooks class.
 */
class ThemeBreakpointsJsHooksTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'breakpoint',
    'theme_breakpoints_js',
    'breakpoint_module_test',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    \Drupal::service('theme_installer')->install(['breakpoint_theme_test']);
    \Drupal::theme()->setActiveTheme(\Drupal::service('theme.initialization')->initTheme('breakpoint_theme_test'));
  }

  /**
   * Tests the implementation of hook page_attachments.
   */
  public function testHookPageAttachments(): void {
    $themeBreakPointsJs = \Drupal::service('theme_breakpoints_js');
    $hooks = new ThemeBreakpointsJsHooks($themeBreakPointsJs);

    $expected_breakpoints = [
        [
          'name' => 'mobile',
          'mediaQuery' => '(min-width: 0px)',
          'multipliers' => ['1x'],
        ],
        [
          'name' => 'narrow',
          'mediaQuery' => '(min-width: 560px)',
          'multipliers' => ['1x'],
        ],
        [
          'name' => 'wide',
          'mediaQuery' => '(min-width: 851px)',
          'multipliers' => ['1x'],
        ],
        [
          'name' => 'tv',
          'mediaQuery' => 'only screen and (min-width: 1220px)',
          'multipliers' => ['1x'],
        ],
    ];

    $page = [];
    $hooks->pageAttachments($page);

    $breakpoints = json_decode($page['#attached']['drupalSettings']['theme_breakpoints'],
      TRUE, 512, JSON_THROW_ON_ERROR);

    $this->assertEquals($expected_breakpoints, $breakpoints);
    $this->assertContains('theme_breakpoints_js/breakpointsLoader', $page['#attached']['library']);
  }

}
