<?php

declare(strict_types=1);

namespace Drupal\Tests\theme_breakpoints_js\Kernel;

use Drupal\breakpoint\Breakpoint;
use Drupal\KernelTests\KernelTestBase;
use Drupal\theme_breakpoints_js\ThemeBreakpointsJs;

/**
 * Tests the ThemeBreakpointsJs service.
 */
class ThemeBreakpointsJsTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'system',
    'breakpoint',
    'theme_breakpoints_js',
    'breakpoint_module_test',
  ];

  /**
   * The ThemeBreakpointsJs service.
   *
   * @var \Drupal\theme_breakpoints_js\ThemeBreakpointsJs
   */
  protected ThemeBreakpointsJs $themeBreakPointsJs;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    \Drupal::service('theme_installer')->install(['breakpoint_theme_test']);
    \Drupal::theme()->setActiveTheme(\Drupal::service('theme.initialization')->initTheme('breakpoint_theme_test'));
    $this->themeBreakPointsJs = \Drupal::service('theme_breakpoints_js');
  }

  /**
   * Tests the implementation of hook page_attachments.
   */
  public function testGetBreakpointsForActiveTheme(): void {
    $breakpoints = $this->themeBreakPointsJs->getBreakpointsForActiveTheme();

    $this->assertCount(4, $breakpoints);
    $this->assertEquals(['mobile', 'narrow', 'wide', 'tv'], array_keys($breakpoints));
    $this->assertContainsOnlyInstancesOf(Breakpoint::class, $breakpoints);
  }

}
